from sw import *
from os.path import isfile
from datetime import datetime
import shutil

class Command:
    def run(self):
        fn = file_get_name(FILENAME_CURRENT)
        if not fn:
            msg_box(BEEP_WARN)
            return
        
        t = datetime.now()
        bak0 = '.bak'
        bak1 = '.{:04}-{:02}-{:02}.bak'.format(t.year, t.month, t.day)
        bak2 = '.{:04}-{:02}-{:02}-{:02}h-{:02}m-{:02}s.bak'.format(t.year, t.month, t.day, t.hour, t.minute , t.second)
        suffix = bak0 if not isfile(fn+bak0) else bak1 if not isfile(fn+bak1) else bak2
        shutil.copyfile(fn, fn+suffix)
        msg_status('Backup: '+fn+suffix)
