#! /usr/bin/env python3
# coding: cp1251

# Authors: Andrey Kvichansky	<kvichans@mail.ru>
#          Alexey T. (SynWrite)
# Revision:	1.1.5
# Last modification: 06 dec 2014

import   sw 

import   os
import   os.path
import   subprocess
import   shutil
from     datetime   import   datetime
import   itertools

ini = os.path.join(os.path.dirname(__file__), 'options.ini')
ini0 = os.path.join(os.path.dirname(__file__), 'options.sample.ini')
if not os.path.isfile(ini) and os.path.isfile(ini0):
    shutil.copyfile(ini0, ini)

class Command:
    def __init__(self):
        pass
        #def __init__
        
    def opt(self):
        if os.path.isfile(ini):
            sw.file_open(ini)
        else:
            sw.msg_box(sw.MSG_ERROR, 'File not found:\n'+ini)
        
    def menu(self):
        sDiffExe= r'c:\Program Files (x86)\WinMerge\WinMergeU.exe'
        sBkDir  = 'bak\\'
        nMaxBks = 9
        
        sDiffExe = sw.ini_read(ini, 'opt', 'tool', sDiffExe)
        sBkDir   = sw.ini_read(ini, 'opt', 'folder', 'bak') + '\\' 
        nMaxBks  = int(sw.ini_read(ini, 'opt', 'menu_items', str(nMaxBks)))
            
        sDiffExe = sDiffExe.replace('{SynDir}', sw.app_exe_dir())
        
        if not os.path.isfile(sDiffExe):
            sw.msg_box(sw.MSG_ERROR, 'File not found, fix options file:\n' + sDiffExe)
            return
            
        if not sw.ed.get_filename():
            sw.msg_box(sw.MSG_WARN, 'Save file first')
            return
        
        sWkFile  = sw.file_get_name(sw.FILENAME_CURRENT)
        sWkDir   = os.path.dirname(sWkFile)+'\\'
        sWkFName = os.path.basename(sWkFile)
        sWkExt   = sWkFName[sWkFName.rfind('.'):]
        sWkStem  = sWkFName[:sWkFName.rfind('.')]
        if os.path.isdir(sWkDir+sBkDir):
            root, dirs, files = list(os.walk(sWkDir+sBkDir))[0]
            prevs   = list((f,os.path.getmtime(root+f)) for f in files if f.startswith(sWkStem) and f.endswith(sWkExt))
            prevs   = sorted(prevs, key=lambda ft: ft[1], reverse=True)
            prevs   = list(zip(itertools.count(1), prevs))
            prevs   = prevs[:nMaxBks]
        else:
            prevs   = ()
        tNow   = datetime.now()
        months   = ('jan','feb','mar','apr','may','jun','jul','aug','sep','oct','nov','dec')
        sSfx   = '_{:02}{}{}-{:02}'.format(tNow.day, months[tNow.month-1], tNow.year%100, tNow.hour)
        sBkDSSE   = sBkDir+sWkStem+sSfx+sWkExt                                    # Dir+Stem+Sfx+Ext
        what   = sw.dlg_menu(sw.MENU_STD, ''
             , '\n'.join(
             [   '&Save as       "{}"...'.format(sBkDSSE)                         # 0
             ,   '-'
             ]+['(&{}) Diff with "{}"'.format(n,sBkDir+f) for n,(f,t) in prevs]   # 2..
             ))
        if 0:pass # cases
        elif -1==what or None==what:
            return
        elif 0==what:
            if not os.path.isdir(sWkDir+sBkDir):
                os.mkdir(sWkDir+sBkDir)
            sBkStem   = sw.dlg_input('Save copy with stamp:', sWkStem+sSfx, '','')
            if sBkStem is None or 0==len(sBkStem): return
            sBkFile   = sWkDir+sBkDir+sBkStem+sWkExt
            shutil.copyfile(sWkFile, sBkFile)
        else:
            sBkFile   = sWkDir+sBkDir+prevs[what-2][1][0]
            subprocess.Popen((sDiffExe, sWkFile, sBkFile))
    #def menu
