"use strict";

var _get = function get(object, property, receiver) {
  var desc = Object.getOwnPropertyDescriptor(object, property);

  if (desc === undefined) {
    var parent = Object.getPrototypeOf(object);

    if (parent === null) {
      return undefined;
    } else {
      return get(parent, property, receiver);
    }
  } else if ("value" in desc && desc.writable) {
    return desc.value;
  } else {
    var getter = desc.get;
    if (getter === undefined) {
      return undefined;
    }
    return getter.call(receiver);
  }
};

var _inherits = function (child, parent) {
  if (typeof parent !== "function" && parent !== null) {
    throw new TypeError("Super expression must either be null or a function, not " + typeof parent);
  }
  child.prototype = Object.create(parent && parent.prototype, {
    constructor: {
      value: child,
      enumerable: false,
      writable: true,
      configurable: true
    }
  });
  if (parent) child.__proto__ = parent;
};

var Container = require("./container");

// CSS at-rule like “this.keyframes name { }”.
//
// Can contain declarations (like this.font-face or this.page) ot another rules.
var AtRule = (function () {
  var _Container = Container;
  var AtRule = function AtRule(defaults) {
    this.type = "atrule";
    _get(Object.getPrototypeOf(AtRule.prototype), "constructor", this).call(this, defaults);
  };

  _inherits(AtRule, _Container);

  // Stringify at-rule
  AtRule.prototype.stringify = function (builder, semicolon) {
    var name = "@" + this.name;
    var params = this.params ? this.stringifyRaw("params") : "";

    if (typeof this.afterName != "undefined") {
      name += this.afterName;
    } else if (params) {
      name += " ";
    }

    if (this.nodes) {
      this.stringifyBlock(builder, name + params);
    } else {
      var before = this.style("before");
      if (before) builder(before);
      var end = (this.between || "") + (semicolon ? ";" : "");
      builder(name + params + end, this);
    }
  };

  // Hack to mark, that at-rule contains children
  AtRule.prototype.append = function (child) {
    if (!this.nodes) this.nodes = [];
    return _get(Object.getPrototypeOf(AtRule.prototype), "append", this).call(this, child);
  };

  // Hack to mark, that at-rule contains children
  AtRule.prototype.prepend = function (child) {
    if (!this.nodes) this.nodes = [];
    return _get(Object.getPrototypeOf(AtRule.prototype), "prepend", this).call(this, child);
  };

  // Hack to mark, that at-rule contains children
  AtRule.prototype.insertBefore = function (exist, add) {
    if (!this.nodes) this.nodes = [];
    return _get(Object.getPrototypeOf(AtRule.prototype), "insertBefore", this).call(this, exist, add);
  };

  // Hack to mark, that at-rule contains children
  AtRule.prototype.insertAfter = function (exist, add) {
    if (!this.nodes) this.nodes = [];
    return _get(Object.getPrototypeOf(AtRule.prototype), "insertAfter", this).call(this, exist, add);
  };

  return AtRule;
})();

module.exports = AtRule;