"use strict";

var _get = function get(object, property, receiver) {
  var desc = Object.getOwnPropertyDescriptor(object, property);

  if (desc === undefined) {
    var parent = Object.getPrototypeOf(object);

    if (parent === null) {
      return undefined;
    } else {
      return get(parent, property, receiver);
    }
  } else if ("value" in desc && desc.writable) {
    return desc.value;
  } else {
    var getter = desc.get;
    if (getter === undefined) {
      return undefined;
    }
    return getter.call(receiver);
  }
};

var _inherits = function (child, parent) {
  if (typeof parent !== "function" && parent !== null) {
    throw new TypeError("Super expression must either be null or a function, not " + typeof parent);
  }
  child.prototype = Object.create(parent && parent.prototype, {
    constructor: {
      value: child,
      enumerable: false,
      writable: true,
      configurable: true
    }
  });
  if (parent) child.__proto__ = parent;
};

var Declaration = require("./declaration");
var Container = require("./container");
var Comment = require("./comment");
var AtRule = require("./at-rule");
var Result = require("./result");
var Rule = require("./rule");

// Root of CSS
var Root = (function () {
  var _Container = Container;
  var Root = function Root(defaults) {
    this.type = "root";
    this.nodes = [];
    _get(Object.getPrototypeOf(Root.prototype), "constructor", this).call(this, defaults);
  };

  _inherits(Root, _Container);

  // Fix space when we remove first child
  Root.prototype.remove = function (child) {
    child = this.index(child);

    if (child === 0 && this.nodes.length > 1) {
      this.nodes[1].before = this.nodes[child].before;
    }

    return _get(Object.getPrototypeOf(Root.prototype), "remove", this).call(this, child);
  };

  // Fix spaces on insert before first rule
  Root.prototype.normalize = function (child, sample, type) {
    var nodes = _get(Object.getPrototypeOf(Root.prototype), "normalize", this).call(this, child);

    if (sample) {
      if (type == "prepend") {
        if (this.nodes.length > 1) {
          sample.before = this.nodes[1].before;
        } else {
          delete sample.before;
        }
      } else {
        for (var i = 0; i < nodes.length; i++) {
          if (this.first != sample) nodes[i].before = sample.before;
        }
      }
    }

    return nodes;
  };

  // Stringify styles
  Root.prototype.stringify = function (builder) {
    this.stringifyContent(builder);
    if (this.after) builder(this.after);
  };

  // Generate processing result with optional source map
  Root.prototype.toResult = function () {
    var opts = arguments[0] === undefined ? {} : arguments[0];
    return new Result(this, opts);
  };

  return Root;
})();

module.exports = Root;