"use strict";

var _prototypeProperties = function (child, staticProps, instanceProps) {
  if (staticProps) Object.defineProperties(child, staticProps);
  if (instanceProps) Object.defineProperties(child.prototype, instanceProps);
};

var _get = function get(object, property, receiver) {
  var desc = Object.getOwnPropertyDescriptor(object, property);

  if (desc === undefined) {
    var parent = Object.getPrototypeOf(object);

    if (parent === null) {
      return undefined;
    } else {
      return get(parent, property, receiver);
    }
  } else if ("value" in desc && desc.writable) {
    return desc.value;
  } else {
    var getter = desc.get;
    if (getter === undefined) {
      return undefined;
    }
    return getter.call(receiver);
  }
};

var _inherits = function (child, parent) {
  if (typeof parent !== "function" && parent !== null) {
    throw new TypeError("Super expression must either be null or a function, not " + typeof parent);
  }
  child.prototype = Object.create(parent && parent.prototype, {
    constructor: {
      value: child,
      enumerable: false,
      writable: true,
      configurable: true
    }
  });
  if (parent) child.__proto__ = parent;
};

var Container = require("./container");
var Declaration = require("./declaration");
var list = require("./list");

// CSS rule like “a { }”
var Rule = (function () {
  var _Container = Container;
  var Rule = function Rule(defaults) {
    this.type = "rule";
    this.nodes = [];
    _get(Object.getPrototypeOf(Rule.prototype), "constructor", this).call(this, defaults);
  };

  _inherits(Rule, _Container);

  // Stringify rule
  Rule.prototype.stringify = function (builder) {
    this.stringifyBlock(builder, this.stringifyRaw("selector"));
  };

  _prototypeProperties(Rule, null, {
    selectors: {

      // Shortcut to get selectors as array

      get: function () {
        return list.comma(this.selector);
      },
      set: function (values) {
        this.selector = values.join(", ");
      },
      enumerable: true
    }
  });

  return Rule;
})();

module.exports = Rule;