/*
 * Decompiled with CFR 0.152.
 */
package moi.tcplugins.preview;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.tika.exception.TikaException;
import org.apache.tika.exception.WriteLimitReachedException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.pdf.PDFParser;
import org.apache.tika.sax.BodyContentHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import plugins.wcx.HeaderData;
import plugins.wcx.OpenArchiveData;
import plugins.wcx.WCXPluginAdapter;

public class PreviewPlugin
extends WCXPluginAdapter {
    final Logger log = LoggerFactory.getLogger(PreviewPlugin.class);
    private final String IMPORTANT_PREFIX = "pdf:docinfo:";

    public Object openArchive(OpenArchiveData archiveData) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".openArchive(archiveData)");
        }
        File path = new File(archiveData.getArcName());
        CatalogInfo catalogInfo = new CatalogInfo();
        catalogInfo.arcName = archiveData.getArcName();
        try {
            this.parse(catalogInfo, path, 10000);
        }
        catch (Throwable e) {
            catalogInfo.throwable = e;
        }
        try {
            catalogInfo.linesAsFiles = this.linesAsFiles(catalogInfo.contents, 60, 75, 15);
        }
        catch (Throwable e) {
            catalogInfo.nonBlockingthrowable = e;
        }
        return catalogInfo;
    }

    private void parse(CatalogInfo catalogInfo, File path, int writeLimit) throws IOException, TikaException, SAXException {
        long before;
        Metadata metadata;
        BodyContentHandler handler;
        block11: {
            if (this.log.isDebugEnabled()) {
                this.log.debug("in parse: path=[" + path + "]");
            }
            handler = new BodyContentHandler(writeLimit);
            metadata = new Metadata();
            FileInputStream inputStream = null;
            ParseContext pcontext = new ParseContext();
            PDFParser pdfparser = new PDFParser();
            before = System.currentTimeMillis();
            try {
                try {
                    inputStream = new FileInputStream(path);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("in parse: pcontext=[" + pcontext + "]; pdfparser=[" + pdfparser + "]; inputStream=[" + inputStream + "]; metadata=[" + metadata + "]");
                    }
                    pdfparser.parse((InputStream)inputStream, (ContentHandler)handler, metadata, pcontext);
                    catalogInfo.everythingRead = true;
                }
                catch (WriteLimitReachedException e) {
                    catalogInfo.everythingRead = false;
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    break block11;
                }
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    inputStream.close();
                }
                throw throwable;
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
        long after = System.currentTimeMillis();
        catalogInfo.contents = handler.toString();
        this.extractMetada(catalogInfo, metadata);
        if (this.log.isDebugEnabled()) {
            this.log.debug("time:" + (after - before) + " millisecs");
            this.log.debug("Contents of the PDF :" + handler.toString().length() + " bytes length");
        }
    }

    private List<String> linesAsFiles(String contents, int minLineLength, int maxLineLength, int maxNumLines) {
        ArrayList<String> linesAsFiles = new ArrayList<String>();
        String s = contents.replaceAll("[^a-zA-Z0-9 ]", "-");
        StringTokenizer tokenizer = new StringTokenizer(s, " ,;\n");
        StringBuffer sb = new StringBuffer();
        while (tokenizer.hasMoreElements() && linesAsFiles.size() < maxNumLines) {
            String next = tokenizer.nextToken();
            this.insert(linesAsFiles, sb, next, minLineLength, maxLineLength, maxNumLines);
        }
        if (linesAsFiles.size() < maxNumLines) {
            linesAsFiles.add(sb.toString());
        }
        return linesAsFiles;
    }

    private void insert(List<String> linesAsFiles, StringBuffer sb, String next, int minLineLength, int maxLineLength, int maxNumLines) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("insert: linesAsFiles.size=" + linesAsFiles.size() + ";sb=[" + sb + "]; next=[" + next + "].");
        }
        if (sb.length() + " ".length() + next.length() > maxLineLength) {
            if (sb.length() >= minLineLength) {
                linesAsFiles.add(sb.toString());
                if (linesAsFiles.size() < maxNumLines) {
                    sb.delete(0, sb.length());
                    this.insert(linesAsFiles, sb, next, minLineLength, maxLineLength, maxNumLines);
                }
            } else {
                int addNumChars = maxLineLength - sb.length() - " ".length();
                sb.append(" " + next.substring(0, addNumChars));
                linesAsFiles.add(sb.toString());
                if (linesAsFiles.size() < maxNumLines) {
                    sb.delete(0, sb.length());
                    this.insert(linesAsFiles, sb, next.substring(addNumChars, next.length()), minLineLength, maxLineLength, maxNumLines);
                }
            }
        } else {
            sb.append(" ").append(next);
        }
    }

    private String twoDigits(int number) {
        return number < 10 ? "0" + number : "" + number;
    }

    private void extractMetada(CatalogInfo catalogInfo, Metadata metadata) {
        String name;
        String[] metadataNames = metadata.names();
        String[] values = new String[metadataNames.length];
        catalogInfo.metadataNames = metadataNames;
        catalogInfo.metadataValues = values;
        catalogInfo.sbMetadata = new StringBuffer();
        ArrayList<String> importantMetadataNames = new ArrayList<String>();
        ArrayList<String> importantMetadataValues = new ArrayList<String>();
        int i = 0;
        String[] stringArray = metadataNames;
        int n = metadataNames.length;
        int n2 = 0;
        while (n2 < n) {
            name = stringArray[n2];
            String value = metadata.get(name);
            values[i++] = value;
            String ne = String.valueOf(name) + "=" + value;
            catalogInfo.sbMetadata.append(ne).append("\n");
            String importantName = this.isImportantMetadata(name);
            if (importantName != null) {
                importantMetadataNames.add(importantName);
                importantMetadataValues.add(value);
            }
            ++n2;
        }
        catalogInfo.importantMetadataNames = importantMetadataNames.toArray(new String[0]);
        catalogInfo.importantMetadataValues = importantMetadataValues.toArray(new String[0]);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Metadata of the PDF:");
            stringArray = metadataNames;
            n = metadataNames.length;
            n2 = 0;
            while (n2 < n) {
                name = stringArray[n2];
                this.log.debug(String.valueOf(name) + " : " + metadata.get(name));
                ++n2;
            }
        }
    }

    private String isImportantMetadata(String name) {
        if (name.startsWith("pdf:docinfo:")) {
            return name.substring("pdf:docinfo:".length());
        }
        return null;
    }

    public int closeArchive(Object archiveData) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".closeArchive(archiveData)");
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int processFile(Object archiveData, int operation, String destPath, String destName) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(String.valueOf(this.getClass().getName()) + ".processFile(archiveData, operation=[" + operation + "], destPath=[" + destPath + "];destName=[" + destName + "]");
        }
        catalogInfo = (CatalogInfo)archiveData;
        try {
            block15: {
                if (operation != 2) ** GOTO lbl39
                fullDestName = String.valueOf(destPath == null ? "" : destPath) + destName;
                if (this.log.isDebugEnabled()) {
                    this.log.debug(String.valueOf(this.getClass().getName()) + ".processFile() EXTRACT from:[" + CatalogInfo.access$2(catalogInfo) + "] to: [" + fullDestName + "]");
                }
                if ((ext = this.extension(fullDestName)).equals("exception")) {
                    v0 = new File(fullDestName);
                    if (catalogInfo.throwable == null) {
                        v1 = catalogInfo.nonBlockingthrowable;
                        return this.save(catalogInfo, v0, v1, false);
                    }
                    v1 = catalogInfo.throwable;
                    return this.save(catalogInfo, v0, v1, false);
                }
                if (ext.equals("md")) {
                    is = PreviewPlugin.class.getResourceAsStream("/README.md");
                    return this.copyStream(is, new File(fullDestName), false);
                }
                if (ext.equals("metadata")) {
                    return this.save(catalogInfo, new File(fullDestName), catalogInfo.sbMetadata.toString(), false);
                }
                if (ext.equals("preview") != false) return this.save(catalogInfo, new File(fullDestName), catalogInfo.contents, false);
                if (!catalogInfo.everythingRead) break block15;
                return this.save(catalogInfo, new File(fullDestName), catalogInfo.contents, false);
                {
                    catch (Throwable t) {
                        this.log.error(t.getMessage(), t);
                        return 0;
                    }
                }
            }
            try {
                path = new File(CatalogInfo.access$2(catalogInfo));
                this.parse(catalogInfo, path, -1);
                return this.save(catalogInfo, new File(fullDestName), catalogInfo.contents, false);
            }
            catch (Throwable e) {
                if (this.log.isErrorEnabled()) {
                    this.log.error(String.valueOf(this.getClass().getName()) + ".processFile() TEST " + (destPath == null ? "" : destPath) + destName);
                }
                s = "Error parsing file: " + e.getMessage();
                return this.save(catalogInfo, new File(fullDestName), s, false);
lbl39:
                // 1 sources

                if (operation == 1) {
                    if (this.log.isDebugEnabled() == false) return 0;
                    this.log.debug(String.valueOf(this.getClass().getName()) + ".processFile() TEST " + (destPath == null ? "" : destPath) + destName);
                    return 0;
                }
                if (operation != 0) return 0;
                if (this.log.isDebugEnabled() == false) return 0;
                this.log.debug(String.valueOf(this.getClass().getName()) + ".processFile() SKIP " + (destPath == null ? "" : destPath) + destName);
                return 0;
            }
        }
        catch (RuntimeException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    private String extension(String fileName) {
        String extension = "";
        int i = fileName.lastIndexOf(46);
        if (i > 0) {
            extension = fileName.substring(i + 1);
        }
        return extension;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int readHeader(Object archiveData, HeaderData headerData) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".readHeader(archiveData, headerData)");
        }
        CatalogInfo catalogInfo = null;
        try {
            catalogInfo = (CatalogInfo)archiveData;
            headerData.setArcName(catalogInfo.arcName);
            if (catalogInfo.throwable != null) {
                Throwable t = catalogInfo.throwable;
                this.log.debug("Error parsing file", t);
                switch (catalogInfo.msgCount++) {
                    case 0: {
                        headerData.setFileName(String.valueOf(t.getMessage()) + ".exception");
                        this.log.debug("SUCCESS after throwable");
                        return 0;
                    }
                }
                return 10;
            }
            switch (catalogInfo.msgCount) {
                case 0: {
                    if (catalogInfo.everythingRead) {
                        this.createMainFile(headerData, catalogInfo.arcName, "txt", catalogInfo.contents.length());
                        catalogInfo.msgCount += 2;
                    } else {
                        this.createMainFile(headerData, catalogInfo.arcName, "txt", 0);
                        ++catalogInfo.msgCount;
                    }
                    this.log.debug("SUCCESS on main file" + catalogInfo.msgCount);
                    return 0;
                }
                case 1: {
                    this.createMainFile(headerData, catalogInfo.arcName, "preview", catalogInfo.contents.length());
                    ++catalogInfo.msgCount;
                    return 0;
                }
                case 2: {
                    this.createMainFile(headerData, catalogInfo.arcName, "metadata", catalogInfo.sbMetadata.length());
                    ++catalogInfo.msgCount;
                    return 0;
                }
                case 3: {
                    this.createHelpFile(headerData, catalogInfo.arcName, "README.md", 1000);
                    ++catalogInfo.msgCount;
                    return 0;
                }
                case 4: {
                    if (this.getImportantMetadata(catalogInfo, headerData)) {
                        this.log.debug("SUCCESS 10");
                        return 0;
                    }
                    ++catalogInfo.msgCount;
                }
                case 5: {
                    if (this.getMetadata(catalogInfo, headerData)) {
                        this.log.debug("SUCCESS 11");
                        return 0;
                    }
                    ++catalogInfo.msgCount;
                }
                case 6: {
                    if (!this.getLineAsFile(catalogInfo, headerData)) break;
                    this.log.debug("SUCCESS 12");
                    return 0;
                }
            }
            return 10;
        }
        catch (Throwable e) {
            if (this.log.isErrorEnabled()) {
                this.log.error(e.getMessage(), e);
            }
            if (catalogInfo.msgCount < 100) {
                headerData.setFileName(String.valueOf(e.getMessage()) + ".exception");
                catalogInfo.nonBlockingthrowable = e;
                ++catalogInfo.msgCount;
                this.log.debug("SUCCESS after throwable 2", e);
                return 0;
            }
            this.log.error("E_BAD_DATA", e);
            return 12;
        }
    }

    private void createMainFile(HeaderData headerData, String arcName, String ext, int size) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("createMainFile: arcName=" + arcName + "ext=" + ext + ";size=" + size);
        }
        File f = new File(arcName);
        int index = f.getName().lastIndexOf(".");
        String name = f.getName().substring(0, index);
        f = new File(f.getParent(), String.valueOf(name) + "." + ext);
        headerData.setFileName(f.getName());
        headerData.setUnpSize((long)size);
    }

    private void createHelpFile(HeaderData headerData, String arcName, String name, int size) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("createHelpFile: name=" + name);
        }
        headerData.setFileName(name);
        headerData.setUnpSize((long)size);
    }

    private boolean getMetadata(CatalogInfo catalogInfo, HeaderData headerData) {
        int contador;
        String[] metadataNames = catalogInfo.metadataNames;
        if ((contador = catalogInfo.metadataCounter++) < metadataNames.length) {
            String name = metadataNames[contador];
            String value = catalogInfo.metadataValues[contador].replaceAll("[^a-zA-Z0-9]", "-");
            String ne = String.valueOf(name) + "=" + value;
            headerData.setFileName("all-metadata\\" + ne + ".metadata");
            headerData.setUnpSize((long)catalogInfo.sbMetadata.length());
            return true;
        }
        return false;
    }

    private boolean getImportantMetadata(CatalogInfo catalogInfo, HeaderData headerData) {
        int contador;
        String[] metadataNames = catalogInfo.importantMetadataNames;
        if ((contador = catalogInfo.importantMetadataCounter++) < metadataNames.length) {
            String name = metadataNames[contador];
            String value = catalogInfo.importantMetadataValues[contador];
            String ne = String.valueOf(name) + "=" + value.replaceAll("[^a-zA-Z0-9 ]", "-");
            headerData.setFileName("_" + ne + ".metadata");
            headerData.setUnpSize((long)catalogInfo.sbMetadata.length());
            return true;
        }
        return false;
    }

    private boolean getLineAsFile(CatalogInfo catalogInfo, HeaderData headerData) {
        int contador;
        if ((contador = catalogInfo.linesAsFilesCounter++) < catalogInfo.linesAsFiles.size()) {
            headerData.setFileName(String.valueOf(this.twoDigits(contador)) + "." + catalogInfo.linesAsFiles.get(contador) + ".line");
            headerData.setUnpSize((long)catalogInfo.linesAsFiles.get(contador).length());
            return true;
        }
        return false;
    }

    public int getPackerCaps() {
        return 292;
    }

    private int save(CatalogInfo cinfo, File dest, Throwable t, boolean overwrite) {
        if (this.log.isWarnEnabled()) {
            this.log.warn("saving throwable", t);
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.flush();
        return this.save(cinfo, dest, sw.toString(), overwrite);
    }

    private int save(CatalogInfo cinfo, File dest, String contents, boolean overwrite) {
        if (overwrite) {
            dest.delete();
        }
        if (dest.exists()) {
            return 16;
        }
        try (PrintWriter out = null;){
            try {
                out = new PrintWriter(dest);
                out.print(contents);
            }
            catch (FileNotFoundException fnfe) {
                if (out != null) {
                    out.close();
                }
                return 15;
            }
        }
        return 0;
    }

    private int copyStream(InputStream is, File dest, boolean overwrite) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("copyStream: inputStream=[" + is + ";dest=[" + dest + "]");
        }
        if (overwrite) {
            dest.delete();
        }
        if (dest.exists()) {
            return 16;
        }
        FileOutputStream outStream = null;
        try {
            try {
                int bytesRead;
                outStream = new FileOutputStream(dest);
                byte[] buffer = new byte[8192];
                while ((bytesRead = is.read(buffer)) != -1) {
                    ((OutputStream)outStream).write(buffer, 0, bytesRead);
                }
            }
            catch (FileNotFoundException fnfe) {
                try {
                    if (outStream != null) {
                        ((OutputStream)outStream).close();
                    }
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException ioe) {
                    return 19;
                }
                return 15;
            }
            catch (IOException ioe) {
                try {
                    if (outStream != null) {
                        ((OutputStream)outStream).close();
                    }
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException ioe2) {
                    return 19;
                }
                return 19;
            }
        }
        finally {
            try {
                if (outStream != null) {
                    ((OutputStream)outStream).close();
                }
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ioe) {
                return 19;
            }
        }
        return 0;
    }

    private class CatalogInfo {
        private String arcName;
        public Throwable throwable;
        public Throwable nonBlockingthrowable;
        public int msgCount;
        public int linesAsFilesCounter;
        public List<String> linesAsFiles;
        public int metadataCounter;
        public String[] metadataNames;
        public String[] metadataValues;
        public StringBuffer sbMetadata;
        public int importantMetadataCounter;
        public String[] importantMetadataNames;
        public String[] importantMetadataValues;
        public boolean everythingRead;
        public String contents;

        private CatalogInfo() {
        }
    }
}

