/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.utils;

import java.util.List;
import org.apache.tika.config.ServiceLoader;
import org.apache.tika.utils.CompareUtils;

public class ServiceLoaderUtils {
    public static <T> void sortLoadedClasses(List<T> loaded) {
        loaded.sort(CompareUtils::compareClassName);
    }

    public static <T> T newInstance(String className) {
        return ServiceLoaderUtils.newInstance(className, ServiceLoader.class.getClassLoader());
    }

    public static <T> T newInstance(String className, ClassLoader loader) {
        try {
            return (T)Class.forName(className, true, loader).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }
}

