PRAGMA page_size = 4096;
PRAGMA encoding = "UTF-8";
PRAGMA secure_delete = 0;

-- 1 Random delete
create table users (
	id INT UNSIGNED NOT NULL,
	name TEXT NOT NULL,
	surname TEXT NULL
);

INSERT INTO users 
	(id, name, surname)
	VALUES
	(20001, 'Nele', 'Berger'),
	(20002, 'Lukas', 'Wolff'),
	(20003, 'Dennis', 'Sommer'),
	(20004, 'Meike', 'Bergmann'),
	(20005, 'Anja', 'Roth'),
	(20006, 'Josephine', 'Brandt'),
	(20007, 'Silvia', 'Horn'),
	(20008, 'Meike', 'Winkler'),
	(20009, 'Lara', 'Hoffmann'),
	(20010, 'Emilia', 'Ludwig'),
	(20011, 'Claudia', 'Franke'),
	(20012, 'Emelie', 'Walter'),
	(20013, 'Christoph', 'Hahn'),
	(20014, 'Simone', 'Hartmann'),
	(20015, 'Heinrich', 'Schmitz'),
	(20016, 'Jonas', 'Brandt'),
	(20017, 'Nele', 'Baumann'),
	(20018, 'Anton', 'Weber'),
	(20019, 'Simon', 'Schulze'),
	(20020, 'Yvonne', 'Weiß');

-- 2 Detect generalized types by data if table doesn't have them in DDL
create table items (
	id integer primary key,
	name,
	price,
	qty integer
);

insert into items (name, price, qty) values
	('Fork', NULL, 2),
	('Kettle', 5.3, 12),
	('Bowl', 11.23, NULL),
	('Cup', 17.5, 67);
	
-- 3 The first column is INTEGER PRIMARY KEY, therefore id is stored in rowid
CREATE TABLE books (
	id integer primary key autoincrement, 
	title text not null, 
	author text nut null, 
	isbn text, 
	price real, 
	available integer check (available >= 0)
);

insert into books (id, title, author, isbn, price, available) values 
	(1, 'Steelheart', 'Brandon Sanderson', '978-0385743563', 5.0, 3),
	(2, 'All Our Yesterdays', 'Cristin Terrill', '978-1423176374', 7.3, 10),
	(3, 'Life After Life', 'Jill McCorkle', '978-1616203221', 2.82, 4),
	(4, 'Life After Life', 'Kate Atkinson', '978-0316176491', 8.1, 5),
	(5, 'Foundation', 'Isaac Asimov', '978-0553293357', 12.7, 8),
	(6, 'Dracula', 'Bram Stoker', '978-0486411095', 6.6, 0),
	(32000000, 'Ordinary Grace', 'William Kent Krueger', '978-1451645859', 3.2, 9),
	(8, 'The Nightingale', 'Kristin Hannah', '978-0312577223', 11.0, 1),
	(9, 'The Life We Bury', 'Allen Eskens', '978-1616149987', 5.1, 4);	
	
-- 4 The first column is FLOAT (8 bytes)
CREATE TABLE discounts (
	value real primary key, 
	"desc" text, 
	comment text, 
	qty integer
);

insert into discounts (value, "desc", comment, qty) values 
	(123.1, 'Base discount', 'simple value', 1),
	(123456789.1234, 'Max discount', 'Max value', 11),
	(11.11, 'Float value', 'Another one value', NULL),
	(999999999.99992, 'Another big one discount', NULL, 321),
	(123, 'Integer value', NULL, 123), /* unrecoverable, because 123 is stored as integer */	 
	(987654321111.000061024, 'Test value', 987654321.111000111, NULL);

-- 5 The first column is TEXT
CREATE TABLE goods (
	name text primary key, 
	price real, 
	quantity integer, 
	comment text
);

insert into goods (name, price, quantity, comment) values 
	('Kettle', 10.23, 4, 'Goot kettle! My recommendations!!'),
	('Fork', 1.1, 20000, NULL),
	('Golden Spoon', 2.0, 12, NULL),
	('Simple spoon', 1.0, 11, NULL),
	('Silver fork', 3.01, 123, 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. '),
	('Mi Kettle', 11.123, 12, 'Another one'),
	('Boul', 22.0, 65, NULL);
	
-- 6 The first column is INTEGER but non-PRIMARY KEY (1-8 bytes)
	CREATE TABLE employees (
	id integer not null unique, 
	boss_id integer, 
	name text, 
	salary real, 
	"desc" text
);

insert into employees (id, boss_id, name, salary, "desc") values 
	(1, 2, 'Abba', 0.123, 'Test'),
	(2, 12, 'Gordon Moore', 0.99, NULL),
	(256, 32000, 'John', 1234567890.123, 'Biggy'),
	(32000000000, 111000000000, 'Laaar', 111111.0, NULL),
	(56, 333, 'Maria', 333.333, 'Exists');

-- 7 Text with 2 byte length type
CREATE TABLE goods2 (
	id integer primary key,
	name text, 
	price real, 
	quantity integer,
	comment text
);

insert into goods2 (id, name, price, quantity, comment) values 
	(1, 'Kettle', 10.23, 4, 'Goot kettle!'),
	(2, 'Fork', 1.1, 20000, 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.'),
	(5, 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.', 11.123, 12, 'Short comment'),
	(65000, 'Golden Spoon', 2.0, 12, 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.'),
	(3200000, 'Simple spoon', 1.0, 11, NULL);
	
-- 8 Trunk freelist
CREATE TABLE books2 (
	id integer primary key autoincrement, 
	title text not null, 
	author text nut null, 
	isbn text, price real, 
	available integer check (available >= 0)
);

insert into books2 (id, title, author, isbn, price, available) values 
	(1, 'Steelheart', 'Brandon Sanderson', '978-0385743563', 5.0, 3),
	(2, 'All Our Yesterdays', 'Cristin Terrill', '978-1423176374', 7.3, 10),
	(3, 'Life After Life', 'Jill McCorkle', '978-1616203221', 2.82, 4),
	(4, 'Life After Life', 'Kate Atkinson', '978-0316176491', 8.1, 5),
	(5, 'Foundation', 'Isaac Asimov', '978-0553293357', 12.7, 8),
	(6, 'Dracula', 'Bram Stoker', '978-0486411095', 6.6, 0),
	(7, 'Ordinary Grace', 'William Kent Krueger', '978-1451645859', 3.2, 9),
	(8, 'The Nightingale', 'Kristin Hannah', '978-0312577223', 11.0, 1),
	(9, 'The Life We Bury', 'Allen Eskens', '978-1616149987', 5.1, 4);

-- 9. UTF8
CREATE TABLE lyrics (
	id integer primary key autoincrement, 
	song_id text not null, 
	line text,
	line_no int
);

insert into lyrics (id, song_id, line, line_no) values 
	(5001, 65001, 'Наш Советский Союз покарает', 10),
	(5002, 65001, 'Весь мир, от Европы к Неве, на восток', 11),
	(5003, 65001, 'Над землёй везде будут петь:', 12),
	(5014, 65001, 'Столица, водка, советский медведь наш!', 13),
	(5019, 65001, '(music)', 14);		

-- 1 
delete from users where id == 20002;
delete from users where id == 20020;
delete from users where id == 20017;
delete from users where id == 20005;
delete from users where id == 20003;
delete from users where id == 20008;
delete from users where id == 20007;

-- 2
delete from items where id in (2, 3);

-- 3
delete from books where id in (3, 4, 32000000);

-- 4
delete from discounts where value in (123456789.1234, 11.11, 999999999.99992, 123);

-- 5 
delete from goods where name in ('Simple spoon', 'Mi Kettle');		

-- 6
delete from employees where id in (256, 32000000000);

-- 7
delete from goods2 where id in (2, 5);

-- 8
drop table books2;

-- 9
delete from lyrics where id in (5002, 5014);