/*
 * file contentplug.h
 */
#ifndef CONTENTPLUG_H_INCLUDED
#define CONTENTPLUG_H_INCLUDED


#define ft_nomorefields		0
#define ft_numeric_32		1
#define ft_numeric_64		2
#define ft_numeric_floating 3
#define ft_date				4
#define ft_time				5
#define ft_boolean			6
#define ft_multiplechoice	7
#define ft_string			8
#define ft_fulltext			9
#define ft_datetime			10

/*
 * for ContentGetValue
 */
#define ft_nosuchfield		-1		/* error, invalid field number given */
#define ft_fileerror		-2		/* file i/o error */
#define ft_fieldempty		-3		/* field valid, but empty */
#define ft_ondemand			-4		/* field will be retrieved only when user presses <SPACEBAR> */
#define ft_notsupported		-5		/* function not supported */
#define ft_setcancel		-6		/* user clicked cancel in field editor */
#define ft_delayed			0		/* field takes a long time to extract -> try again in background */

/*
 * for ContentSetValue
 */
#define ft_setsuccess		0		/* setting of the attribute succeeded */

/*
 * for ContentGetSupportedFieldFlags
 */
#define contflags_edit						1	/* The plugin allows to edit (modify) this field */
												/* via Files - Change attributes. This should only */
												/* be returned for fields where it makes sense, e.g. a file date. */
/* Only ONE of the following flags: */
#define contflags_substsize					2	/* use the file size */
#define contflags_substdatetime				4	/* use the file date+time (ft_datetime) */
#define contflags_substdate					6	/* use the file date (fd_date) */
#define contflags_substtime					8   /* use the file time (fd_time) */
#define contflags_substattributes			10	/* use the file attributes (numeric) */
#define contflags_substattributestr			12	/* use the file attribute string in form -a-- */
#define contflags_passthrough_size_float	14	/* pass the size as ft_numeric_floating to ContentGetValue. */
												/* The plugin will then apply the correct units, and return */
												/* the formatted display string in the additional string field. */
#define contflags_substmask					14	/* A combination of all above substituion flags. Should be returned */
												/* for index -1 if the content plugin contains ANY of the substituted fields. */
#define contflags_fieldedit					16	/* If set, TC will show a button >> in change attributes which lets */
												/* the user call the function ContentEditValue. This allows plugins */
												/* to have their own field editors, like the custom editor for tc.comments */
												/* or tc.*date/time fields. */

/*
 * for ContentSendStateInformation
 */
#define contst_readnewdir					1
#define contst_refreshpressed				2
#define contst_showhint						4

/*
 * ContentSetValue
 */
#define setflags_first_attribute			1	/* First attribute of this file */
#define setflags_last_attribute				2	/* Last attribute of this file */
#define setflags_only_date					4	/* Only set the date of the datetime value! */

/*
 * ContentEditValue
 */
#define editflags_initialize				1	/* The data passed to the plugin *
												/* may be used to initialize the edit dialog */

#define CONTENT_DELAYIFSLOW		1	/* ContentGetValue called in foreground */
#define CONTENT_PASSTHROUGH		2	/* If requested via contflags_passthrough_size_float: The size */
									/* is passed in as floating value, TC expects correct value */
									/* from the given units value, and optionally a text string */

typedef struct {
	int		size;
	DWORD	PluginInterfaceVersionLow;
	DWORD	PluginInterfaceVersionHi;
	char	DefaultIniName[MAX_PATH];
} ContentDefaultParamStruct;

typedef struct {
	WORD	wYear;
	WORD	wMonth;
	WORD	wDay;
} tdateformat, *pdateformat;

typedef struct {
	WORD	wHour;
	WORD	wMinute;
	WORD	wSecond;
} ttimeformat, *ptimeformat;

extern int __stdcall	ContentGetDetectString(char *DetectString, int maxlen);
extern int __stdcall	ContentGetSupportedField(int FieldIndex, char *FieldName, char *Units, int maxlen);
extern int __stdcall	ContentGetValue(char *FileName, int FieldIndex, int UnitIndex, void *FieldValue, int maxlen, int flags);
extern void __stdcall	ContentSetDefaultParams(ContentDefaultParamStruct *dps);
extern void __stdcall	ContentPluginUnloading(void);

extern void __stdcall	ContentStopGetValue(char *FileName);
extern int __stdcall	ContentGetDefaultSortOrder(int FieldIndex);

extern int __stdcall	ContentGetSupportedFieldFlags(int FieldIndex);
extern int __stdcall	ContentSetValue(char *FileName, int FieldIndex, int UnitIndex, int FieldType, void *FieldValue, int flags);
extern int __stdcall	ContentEditValue(HWND ParentWin, int FieldIndex, int UnitIndex, int FieldType, void *FieldValue,
							int maxlen, int flags, char *langidentifier);

extern void __stdcall	ContentSendStateInformation(int state, char *path);


#endif /* CONTENTPLUG_H_INCLUDED */
