
--An example of a script for reading text data. 

extension='.csv'
caption='Tektronix 6604'
description='Data file of oscillographs Tektronix series 6000'
data={}
comments={}

function split(str, sep)
    sep = sep or ','
    fields={}
    local matchfunc = string.gmatch(str, "([^"..sep.."]*)")
    if not matchfunc then return {str} end
    for str in matchfunc do
        table.insert(fields, str)
    end
    return fields
end

function readData(path)
    
    local file = assert(io.open(path, "r"))
    
    -- check Tektronix 6604 csv format
    line = file:lines()
    if string.find(line(1), 'Record Length') ~= 2
       or string.find(line(2), 'Sample Interval') ~= 2
       or string.find(line(3), 'Trigger Point') ~= 2
       or string.find(line(4), 'Trigger Time') ~= 2 then
        file:close()  -- ???
        return nil
    end

    -- read data
    file:seek("set") 
    for line in file:lines() do
		fields = split(line, ',')
		local numfields = {}
        for i=4,#fields do
            numfields[i-3] = tonumber(fields[i]) or fields[i]
        end
        table.insert(data, numfields)
    end
    file:close()
	comments["XAxisTitle"]="t, s"
	comments["YAxisTitle"]="U, V"
end

