
--An example of a script for reading binary data.
--Does not support all features of the Tektronix Waveform File Format.

extension='.wfm'
caption='Tektronix .wfm file'
description='Tektronix Waveform File Format'
flags=1
data={}
comments={}

function readData(path)
    
    local file = assert(io.open(path, "rb"))
	local an_integer = string.unpack(">I2", file:read(2))
	local endian = ">"               --big-endian
	if an_integer == 3855 then       --0x0f0f
		endian = "<"                 --little-endian
	elseif an_integer ~= 61680 then  --0xf0f0
		file:close()  -- ???
		return nil    -- endianness not found
	end
		
	local version = string.unpack("c8", file:read(8))

    local v1_offset = 2 -- ":WFM#001"
	if version==":WFM#002" or version==":WFM#003" then
        v1_offset = 0
    elseif version ~=":WFM#001" then
		file:close()  -- ???
		return nil    -- version information not found
    end

	file:seek("set", 11)
    local bytes_to_eof = string.unpack(endian.."I4", file:read(4))
    local bpp = string.unpack("B", file:read(1)) --Number of bytes per point
    local curve_offset = string.unpack(endian.."I4", file:read(4))       

	file:seek("set", 240-v1_offset)
    local code = string.unpack(endian.."I4", file:read(4))
	if code == 0 then
	  dformat = endian.."i2"
	elseif code == 1 then
	  dformat = endian.."i4"
	elseif code == 2 then
	  dformat = endian.."I4"
	elseif code == 3 then
	  dformat = endian.."I8"
	elseif code == 4 then
	  dformat = endian.."f"
	elseif code == 5 then
	  dformat = endian.."d"
	end
	
	
	file:seek("set", 150)
	local num_curves = string.unpack(endian.."I2", file:read(4))   --acquired fast frames

	file:seek("set", 168-v1_offset)
    local vscale = string.unpack(endian.."d", file:read(8))
    local voffset = string.unpack(endian.."d", file:read(8))
	
	file:seek("set", 488-v1_offset)
	local tscale = string.unpack(endian.."d", file:read(8))

	file:seek("set", 818-v1_offset)
	local dsize = string.unpack(endian.."I4", file:read(4))
	local dlen = dsize // bpp
	
-- first add time samples
	local timefields = {}
	for i = 1, dlen do
	  timefields[i] = i * tscale 
	end
	table.insert(data, timefields)
	
--then add the amplitude samples	
	file:seek("set", curve_offset)
	--for i = 1, num_curves do
	  local numfields = {}
	  for j = 1, dlen do
	    numfields[j] = string.unpack(dformat, file:read(bpp)) * vscale + voffset 
	  end
	  table.insert(data, numfields)
	--end

    file:close()
	--comments["XAxisTitle"]="t, s"
	--comments["YAxisTitle"]="U, V"
end
