// crc32tag.cpp : Defines the entry point for the DLL application.
//

#include "stdafx.h"
#include "contplug.h"
#include "zlib.h"
#include <iostream>
#include <fstream>
#include <string>
//#include "DebugMSG.h"

#define wdirtypemax 1024
#define longnameprefixmax 6
#define _detectstring ""
#define fieldcount 3

#ifndef countof
#define countof(str) (sizeof(str)/sizeof(str[0]))
#endif // countof

// read 4K of data at a time
//#define MAX_BUFFER_SIZE 4096
//#define MAX_BUFFER_SIZE 262144
unsigned int MaxBufferSize = 262144;
#define MAX_CACHE_LIST_SIZE 256// ! MINIMUM 1, MAXIMUM 9999 !  size for each of the 256 sub-lists. A good compromise seems to be 256 (see notes below)
								
								/*

								  Notes to help finding the desired MAX_CACHE_LIST_SIZE value:


								  Some stats first: +-362Bytes per line once saved on file on a system that allows maximum 256 character path length (in mem, still 512Bytes)
								  Some stats first: While testing on +3150files, the maximum room per sublist was 8 to 20 entries,
								   which means it can allow MAX_CACHE_LIST_SIZE divided by +-14 in average per +3,15K files count to reach the end before starting overwriting any entry.


								  Accessing cache list speeds theorical compares showing the advantage on the new 256 lists x MAX_CACHE_LIST_SIZE
								   versus the old single list of 8001 size:
								  -----------------------------------
								  For MAX_CACHE_LIST_SIZE=32:     (8001/32)/2 = average of 125x faster, for a 8192/8001 = 1.02x bigger cache list size
								  For MAX_CACHE_LIST_SIZE=64:     (8001/64)/2 = average of 62.5x faster, for a 16384/8001 = 2.04x bigger cache list size
								  For MAX_CACHE_LIST_SIZE=128:     (8001/128)/2 = average of 31.25x faster, for a 32768/8001 = 4.09x bigger cache list size
								  For MAX_CACHE_LIST_SIZE=256:     (8001/256)/2 = average of 15.62x faster, for a 65536/8001 = 8.19x bigger cache list size
								  For MAX_CACHE_LIST_SIZE=512:     (8001/512)/2 = average of 7.81x faster, for a 131072/8001 = 16.38x bigger cache list size
								  For MAX_CACHE_LIST_SIZE=1024:     (8001/1024)/2 = average of 3.90x faster, for a 262144/8001 = 32.76x bigger cache list size
								  For MAX_CACHE_LIST_SIZE=2048:     (8001/2048)/2 = average of 1.95x faster, for a 524288/8001 = 65.52x bigger cache list size


								  Accessing cache list speeds theorical compares showing the advantage on the new 256 lists x MAX_CACHE_LIST_SIZE
								   versus the old single list if it has to keep matching the total sizes:
								  -----------------------------------------------------------------
								  For MAX_CACHE_LIST_SIZE=32:     8001 / (  8192 /   32) = 1 to 31.2x or 100% to   3120%. Average:   15x faster
								  For MAX_CACHE_LIST_SIZE=64:    16002 / ( 16384 /   64) = 1 to 62.5x or 100% to   6250%. Average:   31x faster
								  For MAX_CACHE_LIST_SIZE=128:   32004 / ( 32768 /  128) = 1 to 125x or 100% to   12500%. Average:   62x faster
								  For MAX_CACHE_LIST_SIZE=256:   64008 / ( 65536 /  256) = 1 to 250x or 100% to   25000%. Average:  125x faster
								  For MAX_CACHE_LIST_SIZE=512:  128016 / (131072 /  512) = 1 to 500x or 100% to   50000%. Average:  250x faster
								  For MAX_CACHE_LIST_SIZE=1024: 256032 / (262144 / 1024) = 1 to 1000x or 100% to 100000%. Average:  500x faster
								  For MAX_CACHE_LIST_SIZE=2048: 512064 / (524288 / 2048) = 1 to 2000x or 100% to 200000%. Average: 1000x faster


								  Refreshing before starting overwriting theorical compares:
								  ---------------------------------------------------------
								  Old single cache list of 8001 total lines per 3150 files refreshing\adding : 8001/3150 = 2.54x before overwriting
								  New cache lists of 256x32(8192) total lines per 3150 files refreshing\adding : 32/(3150/256) = 2.6x in average before overwriting
								  New cache lists of 256x64(16384) total lines per 3150 files refreshing\adding : 64/(3150/256) = 5.2x in average before overwriting
								  New cache lists of 256x128(32768) total lines per 3150 files refreshing\adding : 128/(3150/256) = 10.4x in average before overwriting
								  New cache lists of 256x256(65536) total lines per 3150 files refreshing\adding : 256/(3150/256) = 20.8x in average before overwriting
								  New cache lists of 256x512(131072) total lines per 3150 files refreshing\adding : 512/(3150/256) = 41.61x in average before overwriting
								  New cache lists of 256x1024(262144) total lines per 3150 files refreshing\adding : 1024/(3150/256) = 83.22x in average before overwriting
								  New cache lists of 256x2048(524288) total lines per 3150 files refreshing\adding : 2048/(3150/256) = 166.44x in average before overwriting


								  Space taken in memory and disk for 256 cache lists (non-theorical except some of the cache file size):
								  --------------------------------------------------
								    32 =   8192 cache lines, +9MB to the file manager (x86) in memory, should give a cache file size of +-3MB once filled at 100% with datas.
								    64 =  16384 cache lines, +23MB to the file manager (x86) in memory, should give a cache file size of +-6MB once filled at 100% with datas.
								   128 =  32768 cache lines, +35MB to the file manager (x86) in memory, should give a cache file size of +-12MB once filled at 100% with datas.
								   256 =  65536 cache lines, +65MB to the file manager (x86) in memory, should give a cache file size of +-24MB once filled at 100% with datas.
								   512 = 131072 cache lines, +135MB to the file manager (x86) in memory, should give a cache file size of +-47MB once filled at 100% with datas.
								  1024 = 262144 cache lines, +270MB to the file manager (x86) in memory, should give a cache file size of +-94MB once filled at 100% with datas.
								  2048 = 524288 cache lines, +539MB to the file manager (x86) in memory, should give a cache file size of +-188MB once filled at 100% with datas.
								  
								  */

bool GetValueAborted = false;
HINSTANCE hinst;
wchar_t msgCrc32UserAborted[128];
wchar_t msgCrc32ReadError[128];
wchar_t msgCrc32WrongCrc[128];
//wchar_t msgCrc32WrongCrcFromCache[128]; Il n'est pas possible d'ajouter cette variable sans une refonte des fonctions relatives.
//wchar_t msgCrc32OkFromCache[128]; idem.
wchar_t msgCrc32SfvMissing[128];
wchar_t msgCrc32SfvEmpty[128];
wchar_t msgCrc32Ok[128];
wchar_t msgCrc32SfvOk[128];
wchar_t msgCrc32OnDemand[128];
wchar_t msgCrc32Delayed[128];

int Size1;
int Size2;
int Size3;
int TreatSfvAsSpecial;
int CacheLoadFromFile;
int CacheSaveToFile;
int UseCache;
int CacheRefreshAlsoSubReps;
int FolderSearchOnlyMatchingFirstChar_FASTER;
int FolderSearchMaxFilesCount; //-1 = search for all (can be very slow if LOT of sfv in current folder) Bigger/equal to 0 = Maximum searching before returning CRC not found in SFV

wchar_t CacheFileName[wdirtypemax];
wchar_t CacheList[16+(MAX_CACHE_LIST_SIZE*256)][512];//en-tte 16 lignes de 16 index chacun: voir GetCacheListNumberFromCacheListLine() pour la rpartition

int CacheListIndex[256] = {0};	//index utilis  l'criture
//int CacheListSize = 0;	//taille actuelle de la liste. Abandonn depuis la nouvelle cache list de 256 entres.
wchar_t inifilename[wdirtypemax] = L"crc32tag.ini";

char* fieldnames[fieldcount] =
{
	"GetCrc32From",
	"GetCrc32FromFile",
	"CheckCrcFrom"
};

int fieldtypes[fieldcount] =
{
	ft_stringw,
	ft_stringw,
	ft_stringw
};

char* fieldunits_and_multiplechoicestrings[fieldcount] =
{
	"Tag_Crc32|Tag_YesNo|Sfv_Crc32|Sfv_YesNo|Auto_Crc32|Auto_Result|Auto_Result_LegacySlower",
	"NoBrackets|WithBrackets|Force_NoBrackets|Force_WithBrackets|OnlyOnDemand|OnDemand_IfTagName|OnDemand_IfBiggerThanSize1|OnlyIfLesserThanSize2|WithoutMETADATA|OnDemand_WithoutMETADATA",
	"Tag|Tag_OnlyOnDemand|Sfv|Sfv_OnlyOnDemand|Auto|Auto_OnlyOnDemand|Auto_OnDemand_IfBiggerThanSize3"
};

char* strlcpy(char* p1, char* p2, size_t maxSize);
wchar_t* wcslcpy(wchar_t* str1, const wchar_t* str2, int maxSize);
wchar_t* wcslcat(wchar_t* str1, const wchar_t* str2, int maxSize);
char* walcopy(char* outname, const wchar_t* inname, int maxSize);
wchar_t* awlcopy(wchar_t* outname, const char* inname, int maxSize);
BOOL MakeExtraLongNameW(wchar_t* outbuf, const wchar_t* inbuf, int maxSize);
void DisplayLastErrorMsgW(const wchar_t* lpFunction, const wchar_t* lpFileName, UINT msgType);

void mb(const wchar_t* j);
void Crc32TagUpperCase(wchar_t* j);
void Crc32TagAddBrackets(wchar_t* j);
bool GetCacheDataFromFile(const wchar_t* FileName, wchar_t* cache);
//bool CheckCache(const wchar_t* FileName, wchar_t* cache, wchar_t* j);
bool CheckCache(wchar_t* cache, wchar_t* j);
bool GetCrc32FromCache(const wchar_t* FileName, wchar_t* cache, wchar_t* j, wchar_t* ExtraData);
bool CheckMETAext(const wchar_t* FileName);
bool GetCrc32FromFileWithoutMETADATA(const wchar_t* FileName, wchar_t* j);
bool GetCrc32FromFile(const wchar_t* FileName, wchar_t* j);
bool GetCrc32FromTag(const wchar_t* FileName, wchar_t* n);
bool GetPath(const wchar_t* FileName, const wchar_t* cFileName, wchar_t* j);
bool GiveSfvExt(const wchar_t* FileName, wchar_t* j);
bool SearchCrc32IntoSfv(const wchar_t* FileName, wchar_t* cFileName, wchar_t* j);
bool GetParentFolder(const wchar_t* FileName, wchar_t* ReturnParentFolder);
bool GetCrc32FromSfv(const wchar_t* FileName, wchar_t* cFileName, wchar_t* j);
bool CheckSfv(const wchar_t* FileName, wchar_t* cFileName, wchar_t* j);
bool SfvExt(const wchar_t* FileName);
bool ExtractPath(const wchar_t* m, wchar_t* j);
void CacheRefresh(const wchar_t* path);
void Crc32TagIni(const wchar_t* j, const wchar_t* m, wchar_t* l, int maxSize);
int Crc32TagIniInt(const wchar_t* j, const wchar_t* m);
DWORD CalcCRC32(const wchar_t* szFilename, DWORD &dwCrc32, DWORD dwStartPos, __int64 nEndPos);
void AddZeroHeader(wchar_t * j, int maxSize);
int GetCacheListNumberFromCacheListLine(const wchar_t* cache);

#define wafilenamecopy(outname, inname) walcopy(outname, inname, countof(outname))
#define awfilenamecopy(outname, inname) awlcopy(outname, inname, countof(outname))

BOOL APIENTRY DllMain(HINSTANCE hinstDLL, DWORD fdwReason, LPVOID lpvReserved)
{
	switch (fdwReason)
	{
		case DLL_PROCESS_ATTACH :
		{
			hinst = (HINSTANCE)hinstDLL;
			DisableThreadLibraryCalls(hinst);
			break;
		}

		case DLL_PROCESS_DETACH :
			break;
	}
	return TRUE;
}

char* strlcpy(char* p1, char* p2, size_t maxSize)
{
	if ((size_t) strlen(p2) > maxSize)
	{
		strncpy(p1, p2, maxSize - 1);
		p1[maxSize - 1] = 0;
	}
	else
		strcpy(p1, p2);
	return p1;
}

char* walcopy(char* outname, const wchar_t* inname, int maxSize)
{
	if (inname)
	{
		WideCharToMultiByte(CP_ACP, 0, inname, -1, outname, maxSize, NULL, NULL);
		outname[maxSize - 1] = 0;
		return outname;
	}
	else
		return nullptr;
}

wchar_t* awlcopy(wchar_t* outname, const char* inname, int maxSize)
{
	if (inname)
	{
		MultiByteToWideChar(CP_ACP, 0, inname, -1, outname, maxSize);
		outname[maxSize - 1] = 0;
		return outname;
	}
	else
		return nullptr;
}

wchar_t* wcslcpy(wchar_t* str1, const wchar_t* str2, int maxSize)
{
	if ((int)wcslen(str2) >= maxSize - 1)
	{
		wcsncpy(str1, str2, maxSize - 1);
		str1[maxSize - 1] = 0;
	}
	else
		wcscpy(str1, str2);
	return str1;
}

wchar_t* wcslcat(wchar_t* str1, const wchar_t* str2, int maxSize)
{
	int l1 = (int)wcslen(str1);
	if ((int)wcslen(str2) >= maxSize - 1 - l1)
	{
		wcsncat(str1, str2, maxSize - 1 - l1);
		str1[maxSize - 1] = 0;
	}
	else
		wcscat(str1, str2);
	return str1;
}

BOOL MakeExtraLongNameW(wchar_t* outbuf, const wchar_t* inbuf, int maxSize)
{
	if (wcslen(inbuf) > 259)
	{
		if (inbuf[0] == '\\' && inbuf[1] == '\\')
		{   // UNC-Path! Use \\?\UNC\server\share\subdir\name.ext
			wcslcpy(outbuf, L"\\\\?\\UNC", maxSize);
			wcslcat(outbuf, inbuf + 1, maxSize);
		}
		else
		{
			wcslcpy(outbuf, L"\\\\?\\", maxSize);
			wcslcat(outbuf, inbuf, maxSize);
		}
	}
	else
		wcslcpy(outbuf, inbuf, maxSize);
	return (int)wcslen(inbuf) + 3 <= maxSize;
}

void DisplayLastErrorMsgW(const wchar_t* lpFunction, const wchar_t* lpFileName, UINT msgType)
{
	// retrieve the system error message for the last-error code
	LPVOID lpMsgBuf;
	LPVOID lpDisplayBuf;
	DWORD dw = GetLastError();
	if (dw)
	{
		FormatMessageW(FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS, NULL, dw, MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), (wchar_t*) &lpMsgBuf, 0, NULL );
		// display the error message
		size_t s = wcslen((const wchar_t*)lpMsgBuf) + wcslen((const wchar_t*)lpFunction) + 40;
		lpDisplayBuf = (LPVOID)LocalAlloc(LMEM_ZEROINIT, (s + 1)*sizeof(wchar_t));
		_snwprintf((wchar_t*)lpDisplayBuf, s, L"%s failed with error %d: %s", lpFunction, dw, lpMsgBuf);
		wchar_t wbuf[wdirtypemax + longnameprefixmax];
		if (MakeExtraLongNameW(wbuf, lpFileName, wdirtypemax + longnameprefixmax))
		{
			MessageBoxW(nullptr, (const wchar_t*)lpDisplayBuf, (const wchar_t*)wbuf, msgType);
		}
		LocalFree(lpMsgBuf);
		LocalFree(lpDisplayBuf);
	}
}

int __stdcall ContentGetDetectString(char* DetectString, int maxlen)
{
	strlcpy(DetectString, _detectstring, maxlen);
	return 0;
}

int __stdcall ContentGetSupportedField(int FieldIndex, char* FieldName, char* Units, int maxSize)
{
	if (FieldIndex<0 || FieldIndex >= fieldcount)
		return ft_nomorefields;

	strlcpy(FieldName, fieldnames[FieldIndex], maxSize);
	strlcpy(Units, fieldunits_and_multiplechoicestrings[FieldIndex], maxSize);
	return fieldtypes[FieldIndex];
}

void mb(const wchar_t* j)
{
#ifdef _DEBUG
	MessageBoxW(nullptr, j, L"crc32tag content plugin", NULL);
#endif
}

void Crc32TagUpperCase(wchar_t* j)
{
	wchar_t i;
	//uppercase for crc32 result
	for (i = 0; i < 8; i++)
	{
		if (j[i] > 96)
			j[i] = (j[i] - 32);
		else
			j[i] = j[i];
		//j[i]='-';
	}
}

void Crc32TagAddBrackets(wchar_t* j)
{
	wchar_t i;
	//add brackets
	i = (wchar_t)wcslen(j);
	j[i + 0] = ']';
	j[i + 1] = 0;
	_wcsrev(j);
	i = (wchar_t)wcslen(j);
	j[i + 0] = '[';
	j[i + 1] = '_';
	j[i + 2] = 0;
	_wcsrev(j);
}

bool GetCacheDataFromFile(const wchar_t* FileName, wchar_t* cache)
{
	WIN32_FIND_DATAW fd;
	FILETIME lt;
	SYSTEMTIME st;
	HANDLE fh;
	//DWORD handle;
	//DWORD dwSize;
	__int64 filesize;
	int d = 0;
	wchar_t n[512], t[512];

	fh = FindFirstFileW(FileName, &fd);
	if (fh != INVALID_HANDLE_VALUE)
	{
		FindClose(fh);
		wcslcpy(t, FileName, 512);
		filesize = fd.nFileSizeHigh;
		filesize = (filesize<<32) + fd.nFileSizeLow;
		_i64tow(filesize, n, 10);
		wcslcat(t, L", ", 512);
		wcslcat(t, n, 512);
		FileTimeToLocalFileTime(&fd.ftLastWriteTime, &lt);
		FileTimeToSystemTime(&lt, &st);
		d = st.wYear;	_itow(d, n, 10);	wcslcat(t, L", ", 512);	wcslcat(t, n, 512);
		d = st.wMonth;	_itow(d, n, 10);	wcslcat(t, L"/", 512);	wcslcat(t, n, 512);
		d = st.wDay;	_itow(d, n, 10);	wcslcat(t, L"/", 512);	wcslcat(t, n, 512);
		d = st.wHour;	_itow(d, n, 10);	wcslcat(t, L", ", 512);	wcslcat(t, n, 512);
		d = st.wMinute;	_itow(d, n, 10);	wcslcat(t, L":", 512);	wcslcat(t, n, 512);
		d = st.wSecond;	_itow(d, n, 10);	wcslcat(t, L":", 512);	wcslcat(t, n, 512);
		//mb(t); //debug msg
		//strcat(t,", ");
		wcslcpy(cache, t, 512);
		//c:\dev\crc32tag\contentplug.h, 1.199, 24/11/04 14:26
		return true;
	}
	return false;
}


//calculate the list number based on a cachelist line (without crc32 yet)
int GetCacheListNumberFromCacheListLine(const wchar_t* cache)
{
	//cache sample(notice the not added yet crc32 number):   c:\dev\crc32tag\contentplug.h, 1.199, 24/11/04 14:26
	int o = 0;
	int i,p;
	int z = (int)wcslen(cache);
	for (i=0; i < z; i++)
	{
		//p required to prevent crashes since cache[i] sometimes can return higher values with weird characters like ''
		p = (int)cache[i];
		if (p > 255)
			p = 128;
		else if (p < 0)
		p = 127;

		o = o + p;
		if (o > 255)
			o -= 256;
	}
	return o;
}

//bool CheckCache(const wchar_t* FileName, wchar_t* cache, wchar_t* j)
//liste trie 100%?
bool CheckCache(wchar_t* cache, wchar_t* j)
{
	wchar_t n[512], t[512];
	int i;
	int k, m;
	int CacheListNumber = GetCacheListNumberFromCacheListLine(cache);
	//for (i = 0; i < CacheListSize; i++)
	int p = 16+(MAX_CACHE_LIST_SIZE*CacheListNumber);

	for (i = p; i < p+MAX_CACHE_LIST_SIZE; i++)
	{
		k = (int)wcslen(CacheList[i]);
		m = (int)wcslen(cache);
		if ((k - 8) == m)
		{
			wcslcpy(n, CacheList[i], 512);
			wcslcpy(t, n, k - 8 + 1);
			if (!_wcsicmp(t, cache))
			{
				_wcsrev(n);
				wcslcpy(t, n, 9);
				_wcsrev(t);
				wcslcpy(j, t, 512);
				return true;
			}
		}
	}
	return false;
}

bool GetCrc32FromCache(const wchar_t* FileName, wchar_t* cache, wchar_t* j, wchar_t* ExtraData)
{
	// preparer cache et chercher dans CacheList SI UseCache (voir fichier ini)
	if ((GetCacheDataFromFile(FileName, cache)) && (UseCache))
	{
		wcslcat(cache, ExtraData, 512);
		//if (CheckCache(FileName, cache, j))
		if (CheckCache(cache, j))
			return true;
	}
	return false;
}

bool CheckMETAext(const wchar_t* FileName)
{
	wchar_t i;
	wchar_t o[5];
	wchar_t cache[512];
	wcslcpy(cache, FileName, 512);
	_wcsrev(cache);
	for (i = 0; i < 4; i++)
		o[i] = cache[i];
	o[4] = 0;
	if (_wcsicmp(L"3PM.", o) && _wcsicmp(L"VAW.", o))
		return false;
	else
		return true;
}

bool GetCrc32FromFileWithoutMETADATA(const wchar_t* FileName, wchar_t* j)
{
	DWORD dwCRC32, dwErrorCode = NO_ERROR;
	wchar_t i;
	unsigned char o[5];
	FILE* fIn;
	wchar_t cache[512];
	long dwStartPos = 0;
	__int64 nEndPos = 0;

	//lire ID3v2x
	if ((fIn = _wfopen(FileName, L"rb")) == nullptr)
	{
		mb(L"debug null");
		return false;
	}
	else
	{
		for (i = 1; i < 4; i++)
		{
			o[i] = getc(fIn);
		}
		if ((o[1] == 'I') && (o[2] == 'D') && (o[3] == '3') )
		{
			fseek(fIn, 6, SEEK_SET);
			for (i = 1; i < 5; i++)
			{
				o[i] = getc(fIn);
			}
			if (!feof(fIn))
			{
				dwStartPos = ( 10 + o[4] + (o[3]*128) + ((o[2]*128)*128) + (((o[1]*128)*128)*128) );
				fseek(fIn, 0, SEEK_END);
				if (dwStartPos >= ftell(fIn))
				{
					fclose(fIn);
					return false;
				}
			}
			else
			{
				fclose(fIn);
				return false;
			}
		}
	}

/* pas si simple que a. pas le temps pour ces conneries. abandonn.
	//Vrifier la validit de la premire frame dclare par id3v2 ou par dfault = 0
	fseek(fIn,dwStartPos,SEEK_SET);
	for (i=1;i<3;i++) o[i] = getc(fIn);
	//check FF or 52 49. Sometimes orphans 00 values can be encoutered before the first valid frame. Considered as a corrupted id3v2 (?)
	if (!((o[1]==0xFF) || (o[1]==0x52 && o[2]==0x49))){
		fclose(fIn);
		return false;
	}
*/

	//lire ID3v1x
	if (!fseek(fIn, -128, SEEK_END))
	{
		for (i = 1; i < 4; i++)
		{
			o[i] = getc(fIn);
		}
		if ( (o[1] == 'T') && (o[2] == 'A') && (o[3] == 'G') )
		{
			fseek(fIn, 0, SEEK_END);
			nEndPos = (ftell(fIn) - 128);
		}
	}

	fclose(fIn);

	//si pas de META trouv, alors uniquement resultat si extention supporte
	if ((dwStartPos + nEndPos) == 0)
	{
		if (!CheckMETAext(FileName))
		{
			wcslcpy(j, L"", 512);
			return true;
		}
	}
	if (GetCrc32FromCache(FileName, cache, j, L"NOMETA"))
		return true;

	dwErrorCode = CalcCRC32(FileName, dwCRC32, dwStartPos, nEndPos);
	if (dwErrorCode == NO_ERROR)
	{
		_itow(dwCRC32, j, 16);

		//fill with 0's the crc32 if length lesser than 8 (example : FA->000000FA)
		_wcsrev(j);
		for(; wcslen(j) < 8;)
		{
			i = (wchar_t)wcslen(j);
			j[i + 0] = '0';
			j[i + 1] = 0;
		}
		_wcsrev(j);
		Crc32TagUpperCase(j);
		//Comme trouv, alors ajouter a CacheList
		if (!UseCache)
		{
			//if (CheckCache(FileName, cache, j))
			if (CheckCache(cache, j))
			{
				return true;
			}
		}

		int CacheListNumber = GetCacheListNumberFromCacheListLine(cache);//IMPORTANT: doit tre calcul AVANT d'ajouter le chiffre crc
		wcslcat(cache, j, 512);	//ajoute au cache le crc32
		/*wcslcpy(CacheList[CacheListIndex], cache, 512);
		CacheListIndex++;
		if (CacheListSize < CacheListIndex)
		{
			CacheListSize = CacheListIndex;
		}
		if (CacheListIndex >= MAX_CACHE_LIST_SIZE)
		{
			CacheListIndex = 0;
		}*/
		wcslcpy(CacheList[16+(MAX_CACHE_LIST_SIZE*CacheListNumber)+CacheListIndex[CacheListNumber]], cache, 512);
		CacheListIndex[CacheListNumber]++;
		if (CacheListIndex[CacheListNumber] >= MAX_CACHE_LIST_SIZE)
			CacheListIndex[CacheListNumber] = 0;
		//mb(cache);
		return true;
	}
	return false;
}

bool GetCrc32FromFile(const wchar_t* FileName, wchar_t* j)
{
	DWORD dwCRC32, dwErrorCode = NO_ERROR;
	wchar_t i;
	wchar_t cache[512];

	if (GetCrc32FromCache(FileName, cache, j, L""))
		return true;

	//Si pas trouv, alors calcule crc32 a partir du contenu fichier
	dwErrorCode = CalcCRC32(FileName, dwCRC32, 0, 0);
	if (dwErrorCode == NO_ERROR)
	{
		_itow(dwCRC32, j, 16);

		//fill with 0's the crc32 if length lesser than 8 (example : FA->000000FA)
		_wcsrev(j);
		for(; wcslen(j) < 8;)
		{
			i = (wchar_t)wcslen(j);
			j[i + 0] = '0';
			j[i + 1] = 0;
		}
		_wcsrev(j);
		Crc32TagUpperCase(j);
		//Comme trouv, alors ajouter a CacheList
		if (!UseCache)
		{
			//if (CheckCache(FileName, cache, j))
			if (CheckCache(cache, j))
			{
				return true;
			}
		}

		int CacheListNumber = GetCacheListNumberFromCacheListLine(cache);//IMPORTANT: doit tre calcul AVANT d'ajouter le chiffre crc
		wcslcat(cache, j, 512);	//ajoute au cache le crc32
		/*wcslcpy(CacheList[CacheListIndex], cache, 512);
		CacheListIndex++;
		if (CacheListSize < CacheListIndex)
		{
			CacheListSize = CacheListIndex;
		}
		if (CacheListIndex >= MAX_CACHE_LIST_SIZE)
		{
			CacheListIndex = 0;
		}*/
		wcslcpy(CacheList[16+(MAX_CACHE_LIST_SIZE*CacheListNumber)+CacheListIndex[CacheListNumber]], cache, 512);
		CacheListIndex[CacheListNumber]++;
		if (CacheListIndex[CacheListNumber] >= MAX_CACHE_LIST_SIZE)
			CacheListIndex[CacheListNumber] = 0;
		//mb(cache);
		return true;
	}
	else if (GetValueAborted)
	{
		wcslcpy(j, msgCrc32UserAborted, 512);
		return false;
	}
	else
	{
		//DisplayLastErrorMsgW(L"CreateFileW", FileName, NULL);
		wcslcpy(j, msgCrc32ReadError, 512);
		return false;
	}
}

bool GetCrc32FromTag(const wchar_t* FileName, wchar_t* n)
{
	wchar_t j[512];
	int l, m;
	int i;
	wcslcpy(j, FileName, 512);
	_wcsrev(j);
	int k = (int)wcslen(j);
	for (i = 0; i < (k-9); i++)
	{
		if (j[i] == ']' && j[i+9] == '[')
		{
			for (l = 0; l < 8; l++)
			{
				m = j[i + 1 + l];
				if (m != '0' && m != '1' && m != '2' && m != '3' && m != '4' && m != '5' && m != '6' && m != '7' && m != '8' && m != '9' &&
					m != 'A' && m != 'B' && m != 'C' && m != 'D' && m != 'E' && m != 'F' &&
					m != 'a' && m != 'b' && m != 'c' && m != 'd' && m != 'e' && m != 'f')
				{
					break;
				}
				else
				{
					n[l] = m;
				}
			}
			if (l == 8)
			{
				n[8] = 0;
				_wcsrev(n);
				Crc32TagUpperCase(n);
				return true;
			}
		}
	}
	wcslcpy(n, L"", 512);
	return false;
}

bool GetPath(const wchar_t* FileName, const wchar_t* cFileName, wchar_t* j)
{
	int p = (int)((wcslen(FileName)) - (wcslen(cFileName)));
	if (p <= 0)
		return false;
	wcslcpy(j, FileName, p + 1);
	return true;
}

bool GiveSfvExt(const wchar_t* FileName, wchar_t* j)
{
	wchar_t n[512];
	int p = 0;
	int i;
	wcslcpy(n, FileName, 512);
	int k = (int)wcslen(n);
	_wcsrev(n);
	for (i = 0; i < k; i++)
	{
		if (n[i] == '.')
		{
			p = i;
			break;
		}
	}
	if (p == 0)
	{
		wcslcpy(n, FileName, 512);
		wcslcat(n, L".sfv", 512);
	}
	else
	{
		wcslcpy(n, FileName, k - p + 1);
		wcslcat(n, L"sfv", 512);
	}
	wcslcpy(j, n, 512);
	return true;
}

bool SearchCrc32IntoSfv(const wchar_t* SFVFileName, wchar_t* cFileName, wchar_t* CRCreturn)
{
	// FileName = nom du fichier sfv  ouvrir
	// cFileName = nom du fichier  retrouver dans la liste sfv
	// CRCreturn = retour du crc32 si trouv dans le sfv
	wchar_t l[512], n[512], m[512];
	int k;
	wchar_t Crc32Tag[512] = L"init5";
	wcslcpy(n, SFVFileName, 512);
	wcslcat(n, L" ", 512);
	int nL = (int)wcslen(n);
	wcslcpy(m, cFileName, 512);
	wcslcat(m, L" ", 512);
	size_t mL = wcslen(m);

	//Methode alternative
	FILE* fIn;
	wchar_t ligne[512];
	wchar_t mode[20];
	wcslcpy(mode, L"r", 20);
	if ((fIn = _wfopen(SFVFileName, mode)) != nullptr)
	{
		wchar_t bom[4];
		fgetws(bom, countof(bom), fIn);
		if (bom[0] == 0x00EF && bom[1] == 0x00BB && bom[2] == 0x00BF)
			wcslcpy(mode, L"r, ccs=UTF-8", 20);
		fclose(fIn);
	}
	if ((fIn = _wfopen(SFVFileName, mode)) == nullptr)
	{
		mb(L"debug null");
		return false;
	}
	while(fgetws(ligne, countof(ligne), fIn))
	{	//lis fichier jusque fin
		k = (int)wcslen(ligne);
		if ((k > 10) && (ligne[0] != ';'))
		{	//si ligne plus longue que 10 et ne commence pas par ';'
			if ((ligne[k - 1] == 0xA) || (ligne[k - 1] == 0xD))
			{	//retire charactre de fin de ligne s'il existe
				k--;
				ligne[k] = 0;
			}
			if ((k == (nL + 8)) || (k == (mL + 8)))
			{	// si ligne de meme longeur que recherch
				wcslcpy(l, ligne, k - 9 + 1);
				//si noms fichiers identiques
				if (((k == (nL + 8)) && (!_wcsicmp(l, SFVFileName))) || ((k == (mL + 8)) && (!_wcsicmp(l, cFileName))))
				{
					wcslcpy(l, ligne, 512);
					_wcsrev(l);
					wcslcpy(Crc32Tag, l, 9);
					_wcsrev(Crc32Tag);
					wcslcpy(l, L"dummy_[", 512);
					wcslcat(l, Crc32Tag, 512);
					wcslcat(l, L"].bin", 512);
					if (GetCrc32FromTag(l, Crc32Tag))
					{	//si crc present dans la ligne au bon endroit, retourne crc32
						wcslcpy(CRCreturn, Crc32Tag, 512);
						fclose(fIn);
						return true;
					}
					else break;
				}
			}
		}
	}
	fclose(fIn);
	//Ancienne Methode (plus lente  cause de "ifstream" et "getline") A garder au cas-o...
	/*
	string line;
	ifstream myfile (FileName);
	if (myfile.is_open()){
		while (! myfile.eof() ){
			getline (myfile,line);
			if ((line.find(m) == 0) || (line.find(n) == 0)){
				strcpy(l,line.c_str());
				k = strlen(l);
				if ( ((line.find(n) == 0) && (k == (nL+8))) || ((line.find(m) == 0) && (k == (mL+8))) ){
					strrev(l);
					strlcpy(Crc32Tag,l,8);
					strrev(Crc32Tag);
					strcpy(l,"dummy_[");
					strcat(l,Crc32Tag);
					strcat(l,"].bin");
					if (GetCrc32FromTag(l,Crc32Tag)){
						strcpy(CRCreturn,Crc32Tag);
						myfile.close();
						return true;
					}
					else break;
				}
			}
		}
	myfile.close();
	}
	return false;
	*/
return false;
}


bool GetParentFolder(const wchar_t* FileName, wchar_t* ReturnParentFolder)
{
	// c:\folder\file1.txt --> folder
	wchar_t n[512];
	wchar_t f[512] = L"";
	int fs = 0;
	int i;
	wcslcpy(n, FileName, 512);
	int k = (int)wcslen(n);
	_wcsrev(n);
	for (i = 0; i < k; i++)
	{
		if ( (n[i] == '\\' && fs == 0) || (n[i] != '\\' && fs > 0) ) //first folder ending char found or continue filling f with parent folder chars
		{
			f[fs]=n[i];
			f[fs+1]='\0';
			fs++;
		}
		else if (n[i] == '\\' && fs > 0) /*    done grabbing folder name: folder\    */
		{
			if (fs == 1)//folder is 0 chars count. check this just in case but prob not necessary
				return false;
			else
			{
				_wcsrev(f);
				f[fs-1] = '\0';
				wcslcpy(ReturnParentFolder,f,512);
				return true;
			}
		}
		else if (n[i] == ':')//nothing found and no need to keep going
			return false;
	}
	return false;//readed the whole line without finding anything. No parent folder? c:\file.txt
}


bool GetCrc32FromSfv(const wchar_t* FileName, wchar_t* cFileName, wchar_t* j)
{
	// FileName = chemin complet du fichier
	// cFileName = nom du fichier  retrouver dans la liste sfv
	// j = retour du crc32 si trouv dans le sfv
	WIN32_FIND_DATAW FindFileData;
	HANDLE hFind;
	wchar_t pf[512];
	wchar_t n[512];
	wchar_t t[512];
	wchar_t Crc32Tag[512] = L"initL3";
	wcslcpy(n, j, 512);//pourquoi faire?
	wcslcpy(j, L"", 512);
	if (!GiveSfvExt(FileName, n))
		return false;
	//t<-n pour black name: c:\folder\file1.txt --> c:\folder\file1.sfv Note: totalement oubli  quoi peut servir t
	wcslcpy(t, n, 512);
	//recherche dans nom de fichier FileName MAIS avec l'ext sfv (c:\folder\file1.txt --> c:\folder\file1.sfv)
	hFind = FindFirstFileW(n, &FindFileData);
	if (hFind != INVALID_HANDLE_VALUE)
	{
		FindClose(hFind);
		if (SearchCrc32IntoSfv(n, cFileName, Crc32Tag))
		{
			wcslcpy(j, Crc32Tag, 512);
			return true;
		}
	}
	//si pas trouv, recherche dans nom de fichier FileName AVEC l'ext sfv (c:\folder\file1.txt --> c:\folder\file1.txt.sfv)
	wcslcpy(n,FileName,512);
	wcslcat(n, L".sfv", 512);
	hFind = FindFirstFileW(n, &FindFileData);
	if (hFind != INVALID_HANDLE_VALUE)
	{
		FindClose(hFind);
		if (SearchCrc32IntoSfv(n, cFileName, Crc32Tag))
		{
			wcslcpy(j, Crc32Tag, 512);
			return true;
		}
	}
	//si pas trouv, recherche dans le nom du rpertoire parent AVEC l'ext sfv (c:\folder\file1.txt --> c:\folder\folder.sfv)
	if (GetParentFolder(FileName, pf))
	{
		if (!GetPath(FileName, cFileName, n))
			return false;
		wcslcat(n,pf,512);
		wcslcat(n,L".sfv",512);
		hFind = FindFirstFileW(n, &FindFileData);
		if (hFind != INVALID_HANDLE_VALUE)
		{
			FindClose(hFind);
			if (SearchCrc32IntoSfv(n, cFileName, Crc32Tag))
			{
				wcslcpy(j, Crc32Tag, 512);
				return true;
			}
		}
	}

	//DONE

	//si pas trouv, recherche dans le nom du rpertoire GRAND parent AVEC l'ext sfv (c:\folder\file1.txt --> c:\folder\folder.sfv)
	//TODO + SearchCrc32IntoSfv doit etre mis  jour dans ce cas!


	//si pas trouv, recherche dans tous les fichiers *.sfv du mme repertoire avec limite premire lettre du fichier (cFileName[0])  chercher?
	if (FolderSearchMaxFilesCount == 0)
		return false;

	if (!GetPath(FileName, cFileName, n))
		return false;

	if (FolderSearchOnlyMatchingFirstChar_FASTER > 0)
	{
		int s = (int)wcslen(n);
		n[s] = cFileName[0];
		n[s+1] = 0;
	}
	wcslcat(n, L"*.sfv", 512);

	//dw(n);

	hFind = FindFirstFileW(n, &FindFileData);
	if (hFind == INVALID_HANDLE_VALUE)
		return false;
	//si trouv le permier sfv, recherche le nom correspondant
	if (!GetPath(FileName, cFileName, n))
	{
		FindClose(hFind);
		return false;
	}
	wcslcat(n, FindFileData.cFileName, 512);
	if (_wcsicmp(t, n))
	{
		if (SearchCrc32IntoSfv(n, cFileName, Crc32Tag))
		{
			wcslcpy(j, Crc32Tag, 512);
			FindClose(hFind);
			return true;
		}
	}

	if (FolderSearchMaxFilesCount == 1)
	{
		FindClose(hFind);
		return false;
	}

	//si pas de correspondance trouve dans le premier fichier, cherche les sfv les uns apres les autres
	int c = 2;
	while (FindNextFile(hFind, &FindFileData) != 0)
	{
		if (c > FolderSearchMaxFilesCount && FolderSearchMaxFilesCount > 0)
			break;
		if (!GetPath(FileName, cFileName, n))
			break;
		wcslcat(n, FindFileData.cFileName, 512);
		if (_wcsicmp(t, n))
		{
			if (SearchCrc32IntoSfv(n, cFileName, Crc32Tag))
			{
				wcslcpy(j, Crc32Tag, 512);
				FindClose(hFind);
				return true;
			}
		}
		c++;
	}
	FindClose(hFind);
	return false;
}

bool CheckSfv(const wchar_t* FileName, wchar_t* cFileName, wchar_t* j)
{
	FILE* fIn;
	FILE* fTest;
	wchar_t n[2048], p[2048], ligne[2048];
	int m = 0, r = 0;
	int k;
	if (!GetPath(FileName, cFileName, p))
		return false;
	wchar_t mode[20];
	wcslcpy(mode, L"r", 20);
	if ((fIn = _wfopen(FileName, mode)) != nullptr)
	{
		wchar_t bom[4];
		fgetws(bom, countof(bom), fIn);
		if (bom[0] == 0x00EF && bom[1] == 0x00BB && bom[2] == 0x00BF)
			wcslcpy(mode, L"r, ccs=UTF-8", 20);
		fclose(fIn);
	}

	if ((fIn = _wfopen(FileName, mode)) == nullptr)
		return false;

	while (fgetws(ligne, countof(ligne), fIn))
	{	//lis fichier jusque fin
		k = (int)wcslen(ligne);
		if ((k > 10) && (ligne[0] != ';'))
		{	//si ligne plus longue que 10 et ne commence pas par ';'
			if ((ligne[k - 1] == 0xA) || (ligne[k - 1] == 0xD))
			{	//retire charactre de fin de ligne s'il existe
				k--;
				ligne[k] = 0;
			}
			wcslcpy(n, ligne, k - 9 + 1);//ajoute le path au nom de fichier uniquement si pas de path deja existant
			if (n[1] != ':')
			{
				wcslcpy(ligne, p, 2048);
				wcslcat(ligne, n, 2048);
			}
			r++;
			if ((fTest = _wfopen(ligne, L"r")) == nullptr)
				m++;
			else
				fclose(fTest);
		}
	}
	if (r == 0)
		wcslcpy(j, msgCrc32SfvEmpty, 512);
	else if (m == 0)
		wcslcpy(j, msgCrc32SfvOk, 512);
	else
	{
		_itow(m, n, 10);
		wcslcpy(j, n, 512);
		wcslcat(j, L"/", 512);
		_itow(r, n, 10);
		wcslcat(j, n, 512);
		wcslcat(j, L" ", 512);
		wcslcat(j, msgCrc32SfvMissing, 512);
	}
	fclose(fIn);
	return true;
}

bool SfvExt(const wchar_t* FileName)
{
	wchar_t n[512];
	wcslcpy(n, FileName, 512);
	_wcsrev(n);
	if (
		((n[0] == 'v') || (n[0] == 'V')) &&
		((n[1] == 'f') || (n[1] == 'F')) &&
		((n[2] == 's') || (n[2] == 'S')) &&
		(n[3] == '.')
		)
		return true;
	return false;
}

int __stdcall ContentGetValue(char* FileName, int FieldIndex, int UnitIndex, void* FieldValue, int maxSize, int flags)
{
	wchar_t FileNameW[wdirtypemax];
	int retVal = ContentGetValueW(awfilenamecopy(FileNameW, FileName), FieldIndex, UnitIndex, FieldValue, maxSize, flags);
	if (retVal == ft_numeric_floating)
	{
		wchar_t* p = _wcsdup((const wchar_t*)((char*)FieldValue + sizeof(double)));
		walcopy((char*)FieldValue + sizeof(double), p, maxSize - sizeof(double));
		free(p);
	}
	return retVal;
}

int __stdcall ContentGetValueW(wchar_t* FileName, int FieldIndex, int UnitIndex, void* FieldValue, int maxSize, int flags)
{
	WIN32_FIND_DATAW fd;
	//FILETIME lt;
	//SYSTEMTIME st;
	HANDLE fh;
	//DWORD handle;
	//DWORD dwSize;

	wchar_t Crc32Tag[512] = L"init";
	wchar_t Crc32Temp[512] = L"init";
	__int64 filesize;
	GetValueAborted = false;
	wcslcpy((wchar_t*)FieldValue, L"", maxSize/2);

	fh = FindFirstFileW(FileName, &fd);
	if (fh != INVALID_HANDLE_VALUE)
	{
		FindClose(fh);
		if (((fd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) != 0) && ((fd.dwFileAttributes & FILE_ATTRIBUTE_REPARSE_POINT) == 0))
			return ft_fieldempty;
		switch (FieldIndex)
		{
		case 0:	//GetCrc32From
				//"Tag_Crc32|Tag_YesNo|Sfv_Crc32|Sfv_YesNo|Auto_Crc32|Auto_Result|Auto_Result_LegacySlower"
			if ((flags & CONTENT_DELAYIFSLOW) && (UnitIndex != 0) && (UnitIndex != 1))
			{
				wcslcpy((wchar_t*)FieldValue, msgCrc32Delayed, maxSize/2);
				return ft_delayed;
			}
			if ((SfvExt(FileName)) && (TreatSfvAsSpecial))
			{
				//wcslcpy((wchar_t*)FieldValue, L".", maxSize/2);
				return ft_fieldempty;
				break;
			}
			if (UnitIndex == 0)
				GetCrc32FromTag(fd.cFileName, Crc32Tag);
			if (UnitIndex == 1)
			{
				if (GetCrc32FromTag(fd.cFileName, Crc32Tag))
					wcslcpy(Crc32Tag, L"yes", 512);
				else
					wcslcpy(Crc32Tag, L"no", 512);
			}
			if (UnitIndex == 2)
				GetCrc32FromSfv(FileName, fd.cFileName, Crc32Tag);
			if (UnitIndex == 3)
			{
				if (GetCrc32FromSfv(FileName, fd.cFileName, Crc32Tag))
					wcslcpy(Crc32Tag, L"yes", 512);
				else
					wcslcpy(Crc32Tag, L"no", 512);
			}
			if (UnitIndex == 4)
			{
				if (!GetCrc32FromTag(fd.cFileName, Crc32Tag))
					GetCrc32FromSfv(FileName, fd.cFileName, Crc32Tag);
			}
			if (UnitIndex == 5)
			{
				if (GetCrc32FromTag(fd.cFileName, Crc32Tag))
					wcslcpy(Crc32Tag, L"tag", 512);
				else if (GetCrc32FromSfv(FileName, fd.cFileName, Crc32Tag))
					wcslcpy(Crc32Tag, L"sfv", 512);
				else
					wcslcpy(Crc32Tag, L"", 512);
			}
			if (UnitIndex == 6)
			{
				if (GetCrc32FromSfv(FileName, fd.cFileName, Crc32Tag))
				{
					if (GetCrc32FromTag(fd.cFileName, Crc32Tag))
						wcslcpy(Crc32Tag, L"tag/sfv", 512);
					else
						wcslcpy(Crc32Tag, L"sfv", 512);
				}
				else
				{
					if (GetCrc32FromTag(fd.cFileName,Crc32Tag))
						wcslcpy(Crc32Tag, L"tag", 512);
					else
						wcslcpy(Crc32Tag, L"", 512);
				}
			}
			wcslcpy((wchar_t*)FieldValue, Crc32Tag, maxSize/2);
			break;
		case 1:	//GetCrc32FromFile
				//"NoBrackets|WithBrackets|Force_NoBrackets|Force_WithBrackets|OnlyOnDemand|OnDemand_IfTagName|OnDemand_IfBiggerThanSize1|OnlyIfLesserThanSize2|WithoutMETADATA|OnDemand_WithoutMETADATA",
			if ((UnitIndex == 6) || (UnitIndex == 7) || (UnitIndex == 8) || (UnitIndex == 9))
			{
				filesize = fd.nFileSizeHigh;
				filesize = (filesize << 32) + fd.nFileSizeLow;
				if ((UnitIndex == 7) && (filesize>Size2))
					break;
			}
			if (flags & CONTENT_DELAYIFSLOW)
			{
				if ((UnitIndex == 8) || (UnitIndex == 9))
				{
					if (!CheckMETAext(FileName))
						break;
					if (!GetCrc32FromCache(FileName, Crc32Temp, Crc32Tag, L"NOMETA"))
					{
						if (UnitIndex == 8)
						{
							wcslcpy((wchar_t*)FieldValue, msgCrc32Delayed, maxSize/2);
							return ft_delayed;
						}
						if (UnitIndex == 9)
						{
							wcslcpy((wchar_t*)FieldValue, msgCrc32OnDemand, maxSize/2);
							return ft_ondemand;
						}
					}
				}
				else if (!GetCrc32FromCache(FileName, Crc32Temp, Crc32Tag, L""))
				{
					if (UnitIndex == 4)
					{
						wcslcpy((wchar_t*)FieldValue, msgCrc32OnDemand, maxSize/2);
						return ft_ondemand;
					}
					if ((UnitIndex == 6) && (filesize>Size1))
					{
						wcslcpy((wchar_t*)FieldValue, msgCrc32OnDemand, maxSize/2);
						return ft_ondemand;
					}
					if (GetCrc32FromTag(fd.cFileName,Crc32Tag) && (UnitIndex == 5))
					{
						wcslcpy((wchar_t*)FieldValue, msgCrc32OnDemand, maxSize/2);
						return ft_ondemand;
					}
					wcslcpy((wchar_t*)FieldValue, msgCrc32Delayed, maxSize/2);
					return ft_delayed;
				}
			}
			if ((UnitIndex == 8) || (UnitIndex == 9))
			{
				if (GetCrc32FromFileWithoutMETADATA(FileName, Crc32Tag))
					wcslcpy((wchar_t*)FieldValue, Crc32Tag, maxSize/2);
				else
					wcslcpy((wchar_t*)FieldValue, L"BAD META?", maxSize/2);
				break;
			}
			if (GetCrc32FromTag(fd.cFileName,Crc32Tag) && ((UnitIndex == 0) || (UnitIndex == 1)))
				break;
			if (GetCrc32FromFile(FileName, Crc32Tag))
			{
				if ((UnitIndex == 1)||(UnitIndex == 3))
					Crc32TagAddBrackets(Crc32Tag);
			}
			else if ((UnitIndex != 4) && (UnitIndex != 5) && (!GetValueAborted))
				wcslcpy(Crc32Tag, L"", 512);
			wcslcpy((wchar_t*)FieldValue, Crc32Tag, maxSize/2);
			break;
		case 2:	//CheckCrcFrom
			//"Tag|Tag_OnlyOnDemand|Sfv|Sfv_OnlyOnDemand|Auto|Auto_OnlyOnDemand|Auto_OnDemand_IfBiggerThanSize3"
			if (UnitIndex == 6)
			{
				filesize = fd.nFileSizeHigh;
				filesize = (filesize << 32) + fd.nFileSizeLow;
			}
			if (flags & CONTENT_DELAYIFSLOW)
			{
				if ((UnitIndex == 0) || (UnitIndex == 1))
					if (!GetCrc32FromTag(fd.cFileName, Crc32Tag))
						break;
				if (GetCrc32FromCache(FileName, Crc32Temp, Crc32Tag, L""))
				{
					wcslcpy((wchar_t*)FieldValue, msgCrc32Delayed, maxSize/2);
					return ft_delayed;
				}
				if ((UnitIndex == 1) || (UnitIndex == 3) || (UnitIndex == 5))
				{
					wcslcpy((wchar_t*)FieldValue, msgCrc32OnDemand, maxSize/2);
					return ft_ondemand;
				}
				if ((UnitIndex == 6) && (filesize>Size3))
				{
					wcslcpy((wchar_t*)FieldValue, msgCrc32OnDemand, maxSize/2);
					return ft_ondemand;
				}
				wcslcpy((wchar_t*)FieldValue, msgCrc32Delayed, maxSize/2);
				return ft_delayed;
			}
			if ((SfvExt(FileName)) && (TreatSfvAsSpecial))
			{
				if (CheckSfv(FileName,fd.cFileName,Crc32Tag))
					wcslcpy((wchar_t*)FieldValue, Crc32Tag, maxSize/2);
				else
					wcslcpy((wchar_t*)FieldValue, L"internal error !", maxSize/2);
				break;
			}
			if ((UnitIndex == 0) || (UnitIndex == 1))
			{
				if (!GetCrc32FromTag(fd.cFileName, Crc32Tag))
					break;
			}
			if ((UnitIndex == 2) || (UnitIndex == 3))
			{
				if (!GetCrc32FromSfv(FileName, fd.cFileName, Crc32Tag))
					break;
			}
			if ((UnitIndex == 4) || (UnitIndex == 5) || (UnitIndex == 6))
			{
				if (!GetCrc32FromTag(fd.cFileName, Crc32Tag))
					if (!GetCrc32FromSfv(FileName, fd.cFileName, Crc32Tag))
						break;
			}
			//si arriv ici, Crc32Tag rcupr correctement
			if (!GetCrc32FromFile(FileName, Crc32Temp))
			{
				wcslcpy((wchar_t*)FieldValue, Crc32Temp, maxSize/2);
				break;
			}
			//comparaison crc32
			if (_wcsicmp(Crc32Temp, Crc32Tag))
				wcslcpy((wchar_t*)FieldValue, msgCrc32WrongCrc, maxSize/2);
			else
				wcslcpy((wchar_t*)FieldValue, msgCrc32Ok, maxSize/2);
			break;
/*		case 3:
			if (flags & CONTENT_DELAYIFSLOW){
				strcpy((char*)FieldValue,msgCrc32Delayed);
				return ft_delayed;
			}
			strcpy((char*)FieldValue,"debug");
			break;
*/
		default:
			return ft_nosuchfield;
		}
	}
	else
	{
		return ft_fileerror;
	}
	return fieldtypes[FieldIndex];  // very important!
}

bool ExtractPath(const wchar_t* m, wchar_t* j)
{
	int i;
	int k = (int)wcslen(m);
	for (i = k; i > 0; i--)
	{
		if (m[i] == '\\')
		{
			wcslcpy(j, m, i + 1);
			return true;
		}
	}
	return false;
}

//liste trie 100%?
void CacheRefresh(const wchar_t* path)//Attention  la taille globale de la nouvelle liste trie. Peut-tre lent mais le refresh est occasionnel donc a ne devrait pas poser de problme. Mais vitesse  surveiller au cas-o.
{
	wchar_t t[512];
	int i;
	int k, l;
	//for (i = 0; i < CacheListSize; i++)
	for (i = 16; i < 16+(MAX_CACHE_LIST_SIZE*256); i++)//nouvelle liste trie par CRC32
	{
		k = (int)wcslen(path);
		l = (int)wcslen(CacheList[i]);
		if ((_wcsicmp(CacheList[i], L"")) && (k < l))
		{
			if (!CacheRefreshAlsoSubReps){
				if (ExtractPath(CacheList[i], t))
				{
					wcslcat(t, L"\\", 512);
					if (!_wcsicmp(t, path))	//Arriv ici, permet de vider le cache pour le rep
						wcslcpy(CacheList[i], L"", 512);
				}
				else
					mb(L"Error : Could not Extract path for CacheRefresh");
			}
			else
			{
				wcslcpy(t, CacheList[i], k + 1);
				if (!_wcsicmp(t,path))	//Arriv ici, permet de vider le cache pour le rep + tous ses subrep
					wcslcpy(CacheList[i], L"", 512);
			}
		}
		//	c:\dev\crc32tag\
		//	c:\dev\crc32tag\contentplug.h, 1.199, 24/11/04 14:26
		//	c:\dev\crc32tag\caca\caca.h, 1.199, 24/11/04 14:26
	}
}

void __stdcall ContentSendStateInformation(int state, char* path)
{
	wchar_t pathW[wdirtypemax];
	ContentSendStateInformationW(state, awfilenamecopy(pathW, path));
}

void __stdcall ContentSendStateInformationW(int state, wchar_t* path)
{
	if (state == contst_refreshpressed)
		CacheRefresh(path);
}

void Crc32TagIni(const wchar_t* j, const wchar_t* m, wchar_t* l, int maxSize)
{
	GetPrivateProfileStringW(L"crc32tag", j, m, l, maxSize, inifilename);
	WritePrivateProfileStringW(L"crc32tag", j, l, inifilename);
}

int Crc32TagIniInt(const wchar_t* j, const wchar_t* m)
{
	int i;
	wchar_t l[512];
	GetPrivateProfileStringW(L"crc32tag", j, m, l, 512, inifilename);
	WritePrivateProfileStringW(L"crc32tag", j, l, inifilename);
	i = _wtoi(l);
	return i;
}

void __stdcall ContentSetDefaultParams(ContentDefaultParamStruct* dps)
{
	wchar_t Path[wdirtypemax];
	if (GetModuleFileNameW(hinst, Path, wdirtypemax) != 0)
	{
		wchar_t wd[_MAX_DRIVE];
		wchar_t wp[_MAX_PATH];
		wchar_t wf[_MAX_FNAME];
		_wsplitpath(Path, wd, wp, wf, NULL);
		wcslcpy(inifilename, wd, wdirtypemax);
		wcslcat(inifilename, wp, wdirtypemax);
		wcslcat(inifilename, wf, wdirtypemax);
		wcslcat(inifilename, L".ini", wdirtypemax);

		// see if the INI file already exists in the plugin directory
		WIN32_FIND_DATAW findData;
		SecureZeroMemory(&findData, sizeof(WIN32_FIND_DATAW));
		if (FindFirstFileW(inifilename, &findData) == INVALID_HANDLE_VALUE)
			awlcopy(inifilename, dps->DefaultIniName, wdirtypemax);
	}

	Crc32TagIni(L"Str_UserAborted", L"User Aborted !", msgCrc32UserAborted, 128);
	Crc32TagIni(L"Str_ReadError", L"Read Error !", msgCrc32ReadError, 128);
	Crc32TagIni(L"Str_WrongCrc", L"Wrong Crc !", msgCrc32WrongCrc, 128);
	Crc32TagIni(L"Str_CrcOk", L"OK", msgCrc32Ok, 128);
	Crc32TagIni(L"Str_OnDemand", L"(on demand)", msgCrc32OnDemand, 128);
	Crc32TagIni(L"Str_Delayed", L"- - -", msgCrc32Delayed, 128);
	Crc32TagIni(L"Str_SfvMissing", L"missing !", msgCrc32SfvMissing, 128);
	Crc32TagIni(L"Str_SfvEmpty", L"Empty !", msgCrc32SfvEmpty, 128);
	Crc32TagIni(L"Str_SfvOk", L"(count) OK", msgCrc32SfvOk, 128);

	Size1 = Crc32TagIniInt(L"Int_Size1", L"1048576");//1mb
	Size2 = Crc32TagIniInt(L"Int_Size2", L"512000");//500Kb
	//Size3 = Crc32TagIniInt(L"Int_Size3", L"262144000");//250Mb
	Size3 = Crc32TagIniInt(L"Int_Size3", L"52428800");//50Mb
	TreatSfvAsSpecial = Crc32TagIniInt(L"Int_TreatSfvAsSpecial", L"1");
	UseCache = Crc32TagIniInt(L"Int_UseCache", L"1");
	CacheSaveToFile = Crc32TagIniInt(L"Int_CacheSaveToFile", L"0");
	CacheLoadFromFile = Crc32TagIniInt(L"Int_CacheLoadFromFile", L"0");
	CacheRefreshAlsoSubReps = Crc32TagIniInt(L"Int_CacheRefreshAlsoSubReps", L"1");
	//CacheListSize = 0;

	FolderSearchOnlyMatchingFirstChar_FASTER = Crc32TagIniInt(L"Int_FolderSearchOnlyMatchingFirstChar_FASTER", L"1");
	FolderSearchMaxFilesCount = Crc32TagIniInt(L"Int_FolderSearchMaxFilesCount", L"100");
	if (FolderSearchMaxFilesCount < -1)
		FolderSearchMaxFilesCount = -1;


	MaxBufferSize = Crc32TagIniInt(L"Int_MaxBufferSize", L"262144");//old version was 4096 by fixed MAX_BUFFER_SIZE

	if ( MaxBufferSize <= 0 )
		MaxBufferSize = 262144;
	else if ( MaxBufferSize > 16777216 )
		MaxBufferSize = 262144;

	wchar_t wd[_MAX_DRIVE];
	wchar_t wp[_MAX_PATH];
	wchar_t wf[_MAX_FNAME];
	_wsplitpath(inifilename, wd, wp, wf, NULL);
	wchar_t CacheFileNameDefault[wdirtypemax];
	wcslcpy(CacheFileNameDefault, wd, wdirtypemax);
	wcslcat(CacheFileNameDefault, wp, wdirtypemax);
	wcslcat(CacheFileNameDefault, L"crc32tag.cache.txt", wdirtypemax);
	Crc32TagIni(L"Str_CacheFileName", CacheFileNameDefault, CacheFileName, wdirtypemax);
	if (wcslen(CacheFileName) > 0)
	{
		wchar_t CacheFileNameEx[wdirtypemax];
		ExpandEnvironmentStringsW(CacheFileName, CacheFileNameEx, wdirtypemax);
		wcslcpy(CacheFileName, CacheFileNameEx, wdirtypemax);
		mb(CacheFileName);
	}
	else
	{
		CacheLoadFromFile = 0;
		CacheSaveToFile = 0;
		mb(L"CacheFileName empty and disabled");
	}

	if (CacheLoadFromFile)
	{
		FILE* fIn;
		wchar_t line[514];
		int i = 0;
		int k;
		if ((fIn = _wfopen(CacheFileName, L"r, ccs=UTF-8")) == nullptr)
		{
			//mb(L"Could not open CacheFileName");
			return;
		}
		while (fgetws(line, countof(line), fIn))
		{	//lis fichier jusque fin
			k = (int)wcslen(line);
			if ((line[k - 1] == 0xA) || (line[k - 1] == 0xD))
			{	//retire charactre de fin de ligne s'il existe
				k--;
				line[k] = 0;
			}
			//CacheListSize++;
			if (i<16)//lecture des 256 index de cache par ligne de 16, avec des 0 en en-tte. Exemple: 0055, 0333, ... ---> 00550333...
			{
				if (k == 4*16 && line[0]!= '\\' && line[1]!= ':')//vrifier que la ligne n'est pas corrompue ou de ancien systme de cache
				{
					wchar_t t[20]=L"";
					for (int j=0; j < 16; j++)//assigner les 16 index de la ligne
					{
						//CacheListIndex[(i*16)+j] = (int)255;//dev only
						t[0] = line[0+(j*4)];
						t[1] = line[1+(j*4)];
						t[2] = line[2+(j*4)];
						t[3] = line[3+(j*4)];
						t[4] = 0;
						CacheListIndex[(i*16)+j] = _wtoi(t);
						
						if (CacheListIndex[(i*16)+j] < 0)//some more error checking to prevent crashes if MAX_CACHE_LIST_SIZE gets modified later and some CacheListIndex[x] keept higher value
							CacheListIndex[(i*16)+j] = 0;
						else if (CacheListIndex[(i*16)+j] >= MAX_CACHE_LIST_SIZE)
							CacheListIndex[(i*16)+j] = MAX_CACHE_LIST_SIZE - 1;
					}
				}
				else
					wcslcpy(line,L"0000000000000000000000000000000000000000000000000000000000000000", 514);//non ncssaire pour le moment mais juste pour empecher de possibles erreurs futures d'ajout de code ailleurs
			}
			wcslcpy(CacheList[i], line, 512);
			i++;
			if (16+(MAX_CACHE_LIST_SIZE*256) == i)//garde-fou au cas-o
				break;
		}
		fclose(fIn);
		/*CacheListIndex = Crc32TagIniInt(L"PrivateInt_CacheListIndex", L"0");//lecture de CacheListIndex
		if (CacheListIndex > CacheListSize)
			CacheListIndex = 0;*/
	}
}

//34 --> 0034
void AddZeroHeader(wchar_t * j, int maxSize)
{	
	int i;
	_wcsrev(j);
	for(; (int)wcslen(j) < maxSize;)
	{
		i = (int)wcslen(j);
		j[i + 0] = '0';
		j[i + 1] = 0;
	}
	_wcsrev(j);
}


//liste trie 100?
void __stdcall ContentPluginUnloading(void)
{
	if (CacheSaveToFile)
	{
		FILE* fOut;
		wchar_t line[514];
		int i = 0;
		int k;
		if ((fOut = _wfopen(CacheFileName, L"w, ccs=UTF-8")) == nullptr)
		{
			mb(L"Error : Could not save to the file cache!");
			return;
		}
		//int p = 0;0.25 optimisation abandonned
		//while (CacheListSize > i)
		while (16+(MAX_CACHE_LIST_SIZE*256) > i)
		{//WIP
			if (i<16)//criture des 256 index de cache par ligne de 16, avec des 0 en en-tte. Exemple: 0055, 0333, ... ---> 00550333...
			{
				wchar_t t[20]=L"";
				wcslcpy(line, L"", 514);//vider la ligne
				for (int j=0; j < 16; j++)//assigner les 16 index de la ligne
				{
					_itow(CacheListIndex[(i*16)+j], t, 10);//CacheListIndex vers t
					//remplir l'en-tte de charactres '0' si la longueur est moins de 4
					AddZeroHeader(t,4);
					wcslcat(line, t, 514);//ajouter t  la ligne
				}
			}
			else
				wcslcpy(line, CacheList[i], 514);

			k = (int)wcslen(line);
			line[k] = 0x0A;
			line[k + 1] = 0x00;
			fputws(line, fOut);
			/*if (k > 16)//0.25 opmitisation for ancient system, working well but abandonned: skip empty or very small lines to allow older entries to stay longer
			{
				line[k] = 0x0A;
				line[k + 1] = 0x00;
				fputws(line, fOut);
			}
			else if (i < CacheListIndex)
				p++;*/
			i++;
		}
		fclose(fOut);
		/*CacheListIndex -= p;//keep correct index position

		//_itow(CacheListIndex, line, 10);//sauvegarde de CacheListIndex
		WritePrivateProfileStringW(L"crc32tag", L"PrivateInt_CacheListIndex", line, inifilename);*/
	}

	{
		//mem cleaning at unloading? why?
		int i = 0;
		//while (CacheListSize > i)
		while (16+(MAX_CACHE_LIST_SIZE*256) > i)
		{
			wcslcpy(CacheList[i], L"\0", 514);
			i++;
		}
		//CacheListSize = 0;
		//CacheListIndex = 0;
	}
}

void __stdcall ContentStopGetValue(char* FileName)
{
	GetValueAborted = true;
}

void __stdcall ContentStopGetValueW(wchar_t* FileName)
{
	GetValueAborted = true;
}

DWORD CalcCRC32(const wchar_t* szFilename, DWORD &dwCrc32, DWORD dwStartPos, __int64 nEndPos)
{
	__int64 nPos = 0;
	DWORD dwErrorCode = NO_ERROR;
	HANDLE hFile = nullptr;
	dwCrc32 = crc32(0L, Z_NULL, 0);

	try
	{
		// Open the file
		hFile = CreateFileW(szFilename, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_ARCHIVE | FILE_ATTRIBUTE_HIDDEN | FILE_ATTRIBUTE_READONLY | FILE_ATTRIBUTE_SYSTEM | FILE_FLAG_SEQUENTIAL_SCAN, NULL);
		if (hFile == INVALID_HANDLE_VALUE)
			dwErrorCode = GetLastError();
		else
		{
			//BYTE buffer[MAX_BUFFER_SIZE];
			BYTE *buffer = new BYTE [MaxBufferSize];
			DWORD dwBytesRead;
			BOOL bSuccess;

			//entete  ignorer avec dwStartPos
			while (dwStartPos != 0)
			{
				//if (dwStartPos > sizeof(buffer))
				if (dwStartPos > MaxBufferSize)
				{
					//bSuccess = ReadFile(hFile, buffer, sizeof(buffer), &dwBytesRead, NULL);
					//dwStartPos = dwStartPos - sizeof(buffer);
					bSuccess = ReadFile(hFile, buffer, MaxBufferSize, &dwBytesRead, NULL);
					dwStartPos = dwStartPos - MaxBufferSize;
				}
				else
				{
					bSuccess = ReadFile(hFile, buffer, dwStartPos, &dwBytesRead, NULL);
					dwStartPos = 0;
				}
				if (GetValueAborted || !bSuccess)
				{
					CloseHandle(hFile);
					dwErrorCode = ERROR_CRC;
					delete[] buffer;
					return dwErrorCode;
				}
				else
					nPos = nPos + dwBytesRead;
			}

			while (1)
			{
				if (nEndPos == 0)
				{
					//bSuccess = ReadFile(hFile, buffer, sizeof(buffer), &dwBytesRead, NULL);
					bSuccess = ReadFile(hFile, buffer, MaxBufferSize, &dwBytesRead, NULL);
				}
				else
				{
					//if ((nPos + (__int64)(sizeof(buffer))) < nEndPos)
					if ((nPos + (__int64)(MaxBufferSize)) < nEndPos)
					{
						//bSuccess = ReadFile(hFile, buffer, sizeof(buffer), &dwBytesRead, NULL);
						bSuccess = ReadFile(hFile, buffer, MaxBufferSize, &dwBytesRead, NULL);
					}
					else
						bSuccess = ReadFile(hFile, buffer, (DWORD)(nEndPos - nPos), &dwBytesRead, NULL);
				}

				if (bSuccess && dwBytesRead)
					nPos = nPos + dwBytesRead;
				else
					break;

				if (GetValueAborted)
				{
					CloseHandle(hFile);
					dwErrorCode = ERROR_CRC;
					delete[] buffer;
					return dwErrorCode;
				}

				dwCrc32 = crc32(dwCrc32, buffer, dwBytesRead);
			}
			delete[] buffer;
		}
	}
	catch ( ... )
	{
		// An unknown exception happened
		dwErrorCode = ERROR_CRC;
	}

	if (hFile != NULL)
		CloseHandle(hFile);

	return dwErrorCode;
}
