#XS functions available in script
#standart - ProgressProc, LogProc, RequestProc
#additional - showError 
our $PluginNr;
our $PluginName = "Perl Sample Filesystem";
# parameters - $PluginNr
sub FsInit ($);

#parameters - Path, WIN32_FIND_DATA
#WIN32_FIND_DATA = {dwFileAttributes, nFileSizeHigh, nFileSizeLow, dwReserved0, dwReserved1, cFileName, cAlternateFileName, tLastWriteTime}
#tLastWriteTime - Unix time!!!
#return  Handle(max 256 chars) or "-1" if error
sub FsFindFirst($$);

#parameters - Handle, WIN32_FIND_DATA
#return 0 if error or no more files or 1 
sub FsFindNext($$);

#parameters - Handle
#return 0  
sub FsFindClose($);

#parameters - DefRootName,maxlen
#no return   
sub FsGetDefRootName($$);

#parameters - RemoteName,LocalName, CopyFlags, ri
#return integer result of operation
sub FsGetFile($$$$);

#parameters - LocalName, RemoteName,CopyFlags
#return integer result of operation
sub FsPutFile($$$);

#parameters - OldName, NewName,Move, OverWrite, ri
#return integer result of operation
sub FsRenMovFile($$$$$);

#parameters - RemoteName
#return 0 or 1
sub FsDeleteFile($);

#parameters - RemoteName
#return 0 or 1
sub FsRemoveDir($);

#parameters - Path
#return 0 or 1
sub FsMkDir($);

#parameters - MainWin, RemoteName, Verb
#return integer result of operation
sub FsExecuteFile($$$);

#parameters - RemoteName, NewAttr
#return 0, 1
sub FsSetAttr($$);


#parameters - RemoteName, CreationTime, LastAccessTime, LastWriteTime
#return 0, 1
sub FsSetTime($$$$);

#parameters - DisconnectRoot
#return 0, 1
sub FsDisconnect($);

#parameters - RemoteName, ExtractFlags, TheIcon
#return integer
sub FsExtractCustomIcon($$$);

#parameters - RemoteDir, InfoStartEnd, InfoOperation
#no return
sub FsStatusInfo($$$);


AUTOLOAD {
#	showError($AUTOLOAD . " function not implemented.");
}

##################### IMPLEMENTATION ####################
#########################################################
use TotalCmd::FSPlugin 0.03;
use Win32::File;
use Win32::DriveInfo;
use File::Copy;
use Win32::GUI;
use Win32::GUI::BitmapInline 0.02;
our %Dirs;
our $DiskIcon =  newIcon Win32::GUI::BitmapInline( q(
AAABAAEAECAAAAEABAAoAQAAFgAAACgAAAAQAAAAIAAAAAEABAAAAAAAwAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAACAAACAAAAAgIAAgAAAAIAAgACAgAAAgICAAMDAwAAAAP8AAP8AAAD//wD/AAAA
/wD/AP//AAD///8AAAAAAAAAAAB3d3d3d3d3AH+IiIiIiIdwf4oogAAAh3B////////3cAAAAAAA
AAdwB3d3d3d3cHAHiIiIiIiHAAf4RERESIcAB/hMzMxIhwAH+EjMzEiHAAf4TozMSIcAB/hERERI
hwAH//////+HAAB4iIiIiIcAAAd3d3d3dwCAAwAAAAEAAAAAAAAAAAAAAAAAAIAAAACAAQAAgAEA
AIABAACAAQAAgAEAAIABAACAAQAAgAEAAMABAADgAwAA
) );


sub FsInit($) {
	$PluginNr = shift;
	
}

sub FsFindFirst($$){
	my($Path, $FindData) = (shift, shift);
	my $Dir = substr($Path, 1, length $Path);
	my $elem;
	if($Path eq "\\"){
		$elem = [ map lc($_) . ":", Win32::DriveInfo::DrivesInUse() ];
	}
	else{
		my ($dir, $drive) = ($Path =~ /^\\(([a-z]:).*)/);
		if(!Win32::DriveInfo::IsReady($drive)){
			return INVALID_HANDLE_VALUE;
		}
		else {
			$dir .= "\\" if $dir =~ /^[a-z]:$/;
			opendir (DIR, $dir) || return INVALID_HANDLE_VALUE;
			$elem = [ readdir (DIR) ];
			closedir DIR;
		}
	}
	$Dirs{$Path} = $elem;
	my $file = shift @{$Dirs{$Path}};
	$FindData->{cFileName} = $file;
	if($Path eq "\\"){
		$FindData->{dwFileAttributes} = DIRECTORY;
	}
	else{
		Win32::File::GetAttributes($Dir . "\\" . $file, $FindData->{dwFileAttributes});
		$FindData->{nFileSizeLow} = -s "$Dir\\$file" if (! -d "$Dir\\$file");
		$FindData->{tLastWriteTime} = (stat($Dir . "\\" . $file))[9];
	}
	
	return $Path;
}

sub FsFindNext($$){
	my($Handle, $FindData) = (shift, shift);
	my $Dir = substr($Handle, 1, length $Handle);
	my $elem = $Dirs{$Handle};
	my $file = shift @$elem;
	return 0 if !$file;
	$FindData->{cFileName} = $file;
	if($Handle eq "\\"){
		$FindData->{dwFileAttributes} = DIRECTORY;
	}
	else{
		Win32::File::GetAttributes($Dir . "\\" . $file, $FindData->{dwFileAttributes});
		$FindData->{nFileSizeLow} = -s "$Dir\\$file" if (! -d "$Dir\\$file");
		$FindData->{tLastWriteTime} = (stat($Dir . "\\" . $file))[9];
	}
	return 1;
}

sub FsFindClose($){
	my($Handle) = (shift);
	undef $Dirs{$Handle};
	return 0;
}


sub FsGetDefRootName($$){
	##Don't shift!!! first parameter returns via parameter list;
	$_[0] = substr $PluginName, 0, $_[1];
}
sub FsGetFile($$$$){
	my($RemoteName, $LocalName, $CopyFlags, $ri) = (shift, shift, shift, shift);
	$RemoteName = substr($RemoteName, 1, length $RemoteName);
	return FS_FILE_EXISTS if (-e $LocalName && !($CopyFlags & FS_COPYFLAGS_OVERWRITE));
	unlink $LocalName if -e $LocalName;
	return FS_FILE_USERABORT if ProgressProc($PluginNr,$RemoteName,$LocalName, 0);
	if ($CopyFlags & FS_COPYFLAGS_MOVE){
		rename ($RemoteName, $LocalName) || return FS_FILE_WRITEERROR; 
	}
	else{
		copy  ($RemoteName, $LocalName) || return FS_FILE_WRITEERROR	;
	}
	ProgressProc($PluginNr,$RemoteName,$LocalName, 100);
	return FS_FILE_OK;
	
}

sub FsPutFile($$$){
	my($LocalName, $RemoteName, $CopyFlags) = (shift, shift, shift);
	$RemoteName = substr($RemoteName, 1);
	return FS_FILE_EXISTS if (-e $RemoteName && !($CopyFlags & FS_COPYFLAGS_OVERWRITE));
	return FS_FILE_USERABORT if ProgressProc($PluginNr,$LocalName,$RemoteName, 0);
	if ($CopyFlags & FS_COPYFLAGS_MOVE){
		rename ($LocalName, $RemoteName ) || return FS_FILE_WRITEERROR; 
	}
	else{
		unlink $RemoteName if -e $RemoteName;
		copy  ($LocalName, $RemoteName) || return FS_FILE_WRITEERROR	;
	}
	ProgressProc($PluginNr,$LocalName,$RemoteName, 100);
	return FS_FILE_OK;
	
}

sub FsMkDir($){
	my $Path = shift;
	return 1 if mkdir(substr($Path, 1));
	return 0;
}

sub FsRemoveDir($){
	my $Path = substr shift, 1;
	return rmdir $Path;
}

sub FsDeleteFile($){
	my $File = substr shift, 1;
	return unlink $File;
}

sub FsExtractCustomIcon ($$$){
	if ($_[0] =~ /^\\[a-z]:\\$/){
		$_[2] = $DiskIcon->{-handle};
		return FS_ICON_EXTRACTED;
	}
	return  FS_ICON_USEDEFAULT;
}