/*
//Copyright (C) 2002 Peter Bakota
========================================
 $Name:         ppunpack.h

 $Desc:         ppunpack dll API definitions

 $Author:       Peter Bakota <bakota@tippnet.co.yu>
 $Revision:     1
 $Date:         09.01.2002 9:51:18 PM
 $Comments:     
========================================
*/
#ifndef __PPUNPACK_H
#define __PPUNPACK_H

#include "ppdata.h"

/* Some compilers use a special export keyword */
#ifdef PPUNPACK_EXPORTS
#ifdef WIN32
#define DECLSPEC	__declspec(dllexport)
#else
#define DECLSPEC
#endif
#else
#ifdef WIN32
#define DECLSPEC	__declspec(dllimport)
#else
#define DECLSPEC
#endif
#endif

/* Set up for C function definitions, even when using C++ */
#ifdef __cplusplus
extern "C" {
#endif

extern DECLSPEC unsigned long __stdcall ppLoadFile(char *FileName, char **Buffer, unsigned long *uLen);
extern DECLSPEC void		  __stdcall ppFreeBuffer(char *Buffer, unsigned long uLen);
extern DECLSPEC void          __stdcall ppDecrunchBuffer(unsigned char *Buffer, unsigned char *UBuffer, unsigned long pLen, unsigned long uLen);
extern DECLSPEC int           __stdcall ppGetUSize(char *Buffer, unsigned long pLen, unsigned long *uLen);
extern DECLSPEC int           __stdcall ppGetUSizeFromFile(char *FileName, unsigned long *uLen);
extern DECLSPEC unsigned long __stdcall ppDecrunchFile(char *Src, char *Dest);
extern DECLSPEC int 		  __stdcall ppIsPPFile(char *FileName);

/* Ends C function definitions when using C++ */
#ifdef __cplusplus
}
#endif

#endif // !__PPUNPACK_H
