@echo off

rem Author:   Andrey Dibrov (andry at inbox dot ru)

rem Description:
rem   Script does remove files generated by the gen_branch_workingset.bat
rem   script.

rem Examples:
rem 1. call remove_branch_workingset_files.bat <PathToRootFilesDirectory> <PrefixNameToRootFiles> <PathToWorkingsetCatalogDirectory>

rem Drop last error level
call;

setlocal

if 0%SVNCMD_TOOLS_DEBUG_VERBOSITY_LVL% GEQ 2 (echo.^>^>%0 %*) >&3

set "ROOT_FILES_DIR_PATH=%~1"
set "ROOT_FILES_NAME_PREFIX=%~2"
set "WORKINGSET_CATALOG_DIR_PATH=%~3"

if not exist "%ROOT_FILES_DIR_PATH%\" (
  echo.%~nx0: error: path to root files directory does not exist: "%ROOT_FILES_DIR_PATH%".
  exit /b 1
) >&2

if not defined ROOT_FILES_NAME_PREFIX (
  echo.%~nx0: error: prefix name to root path must be set.
  exit /b 2
) >&2

if not exist "%WORKINGSET_CATALOG_DIR_PATH%\" (
  echo.%~nx0: error: path to workingset catalog directory does not exist: "%WORKINGSET_CATALOG_DIR_PATH%".
  exit /b 3
) >&2

call :DEL_FILE_IF_EXIST "%%ROOT_FILES_DIR_PATH%%\%%ROOT_FILES_NAME_PREFIX%%_root_info.txt" /F /Q
call :DEL_FILE_IF_EXIST "%%ROOT_FILES_DIR_PATH%%\%%ROOT_FILES_NAME_PREFIX%%_root_changeset.lst" /F /Q
call :DEL_FILE_IF_EXIST "%%ROOT_FILES_DIR_PATH%%\%%ROOT_FILES_NAME_PREFIX%%_root_diff.patch" /F /Q
call :DEL_FILE_IF_EXIST "%%ROOT_FILES_DIR_PATH%%\%%ROOT_FILES_NAME_PREFIX%%_root_diff_*.lst" /F /Q
call :DEL_FILE_IF_EXIST "%%ROOT_FILES_DIR_PATH%%\%%ROOT_FILES_NAME_PREFIX%%_root_externals.lst" /F /Q
call :DEL_FILE_IF_EXIST "%%ROOT_FILES_DIR_PATH%%\%%ROOT_FILES_NAME_PREFIX%%_root_files.lst" /F /Q
call :DEL_FILE_IF_EXIST "%%ROOT_FILES_DIR_PATH%%\%%ROOT_FILES_NAME_PREFIX%%_all_files.lst" /F /Q
call :DEL_FILE_IF_EXIST "%%ROOT_FILES_DIR_PATH%%\%%ROOT_FILES_NAME_PREFIX%%_all_files_hash.lst" /F /Q
call :DEL_FILE_IF_EXIST "%%ROOT_FILES_DIR_PATH%%\%%ROOT_FILES_NAME_PREFIX%%_workingset.lst" /F /Q
call :DEL_FILE_IF_EXIST "%%ROOT_FILES_DIR_PATH%%\%%ROOT_FILES_NAME_PREFIX%%_root_status.txt" /F /Q
call :DEL_FILE_IF_EXIST "%%ROOT_FILES_DIR_PATH%%\%%ROOT_FILES_NAME_PREFIX%%_all_status.txt" /F /Q
call :RMDIR_IF_EXIST "%%WORKINGSET_CATALOG_DIR_PATH%%" /S /Q
exit /b 0

:DEL_FILE_IF_EXIST
set "FROMTO_PATH=%~f1"
if not exist "%FROMTO_PATH%" exit /b 255
echo.^>del %2 %3 %4 %5 %6 %7 %8 %9 "%FROMTO_PATH%"
del %2 %3 %4 %5 %6 %7 %8 %9 "%FROMTO_PATH%"
exit /b

:RMDIR_IF_EXIST
set "FROMTO_PATH=%~f1"
if not exist "%FROMTO_PATH%\" exit /b 255
echo.^>rmdir %2 %3 %4 %5 %6 %7 %8 %9 "%FROMTO_PATH%"
rmdir %2 %3 %4 %5 %6 %7 %8 %9 "%FROMTO_PATH%"
exit /b
